/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.OpenApiFunctionDefinition;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OpenApiToolDefinition
extends ToolDefinition {
    private String type = "openapi";
    private final OpenApiFunctionDefinition openapi;

    public OpenApiToolDefinition(OpenApiFunctionDefinition openapi) {
        this.openapi = openapi;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public OpenApiFunctionDefinition getOpenapi() {
        return this.openapi;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("openapi", (JsonSerializable)this.openapi);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static OpenApiToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (OpenApiToolDefinition)jsonReader.readObject(reader -> {
            OpenApiFunctionDefinition openapi = null;
            String type = "openapi";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("openapi".equals(fieldName)) {
                    openapi = OpenApiFunctionDefinition.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            OpenApiToolDefinition deserializedOpenApiToolDefinition = new OpenApiToolDefinition(openapi);
            deserializedOpenApiToolDefinition.type = type;
            return deserializedOpenApiToolDefinition;
        });
    }
}

