/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RequiredFunctionToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class RequiredToolCall
implements JsonSerializable<RequiredToolCall> {
    private String type = "RequiredToolCall";
    private final String id;

    protected RequiredToolCall(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RequiredToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RequiredToolCall)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RequiredToolCall requiredToolCall;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("function".equals(discriminatorValue)) {
                    requiredToolCall = RequiredFunctionToolCall.fromJson(readerToUse.reset());
                    return requiredToolCall;
                }
                requiredToolCall = RequiredToolCall.fromJsonKnownDiscriminator(readerToUse.reset());
                return requiredToolCall;
            }
        });
    }

    static RequiredToolCall fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RequiredToolCall)jsonReader.readObject(reader -> {
            String id = null;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RequiredToolCall deserializedRequiredToolCall = new RequiredToolCall(id);
            deserializedRequiredToolCall.type = type;
            return deserializedRequiredToolCall;
        });
    }
}

