/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponseFormatJsonSchema
implements JsonSerializable<ResponseFormatJsonSchema> {
    private String description;
    private final String name;
    private final BinaryData schema;

    public ResponseFormatJsonSchema(String name, BinaryData schema) {
        this.name = name;
        this.schema = schema;
    }

    public String getDescription() {
        return this.description;
    }

    public ResponseFormatJsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BinaryData getSchema() {
        return this.schema;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("schema");
        this.schema.writeTo(jsonWriter);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ResponseFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return (ResponseFormatJsonSchema)jsonReader.readObject(reader -> {
            String name = null;
            BinaryData schema = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    schema = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ResponseFormatJsonSchema deserializedResponseFormatJsonSchema = new ResponseFormatJsonSchema(name, schema);
            deserializedResponseFormatJsonSchema.description = description;
            return deserializedResponseFormatJsonSchema;
        });
    }
}

