/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunCompletionUsage
implements JsonSerializable<RunCompletionUsage> {
    private final long completionTokens;
    private final long promptTokens;
    private final long totalTokens;

    private RunCompletionUsage(long completionTokens, long promptTokens, long totalTokens) {
        this.completionTokens = completionTokens;
        this.promptTokens = promptTokens;
        this.totalTokens = totalTokens;
    }

    public long getCompletionTokens() {
        return this.completionTokens;
    }

    public long getPromptTokens() {
        return this.promptTokens;
    }

    public long getTotalTokens() {
        return this.totalTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("completion_tokens", this.completionTokens);
        jsonWriter.writeLongField("prompt_tokens", this.promptTokens);
        jsonWriter.writeLongField("total_tokens", this.totalTokens);
        return jsonWriter.writeEndObject();
    }

    public static RunCompletionUsage fromJson(JsonReader jsonReader) throws IOException {
        return (RunCompletionUsage)jsonReader.readObject(reader -> {
            long completionTokens = 0L;
            long promptTokens = 0L;
            long totalTokens = 0L;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completion_tokens".equals(fieldName)) {
                    completionTokens = reader.getLong();
                    continue;
                }
                if ("prompt_tokens".equals(fieldName)) {
                    promptTokens = reader.getLong();
                    continue;
                }
                if ("total_tokens".equals(fieldName)) {
                    totalTokens = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return new RunCompletionUsage(completionTokens, promptTokens, totalTokens);
        });
    }
}

