/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepCompletionUsage;
import com.azure.ai.agents.persistent.models.RunStepDetails;
import com.azure.ai.agents.persistent.models.RunStepError;
import com.azure.ai.agents.persistent.models.RunStepStatus;
import com.azure.ai.agents.persistent.models.RunStepType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class RunStep
implements JsonSerializable<RunStep> {
    private final String id;
    private final String object = "thread.run.step";
    private final RunStepType type;
    private final String assistantId;
    private final String threadId;
    private final String runId;
    private final RunStepStatus status;
    private final RunStepDetails stepDetails;
    private final RunStepError lastError;
    private final long createdAt;
    private final Long expiredAt;
    private final Long completedAt;
    private final Long cancelledAt;
    private final Long failedAt;
    private RunStepCompletionUsage usage;
    private final Map<String, String> metadata;

    private RunStep(String id, RunStepType type, String assistantId, String threadId, String runId, RunStepStatus status, RunStepDetails stepDetails, RunStepError lastError, OffsetDateTime createdAt, OffsetDateTime expiredAt, OffsetDateTime completedAt, OffsetDateTime cancelledAt, OffsetDateTime failedAt, Map<String, String> metadata) {
        this.id = id;
        this.type = type;
        this.assistantId = assistantId;
        this.threadId = threadId;
        this.runId = runId;
        this.status = status;
        this.stepDetails = stepDetails;
        this.lastError = lastError;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.expiredAt = expiredAt == null ? null : Long.valueOf(expiredAt.toEpochSecond());
        this.completedAt = completedAt == null ? null : Long.valueOf(completedAt.toEpochSecond());
        this.cancelledAt = cancelledAt == null ? null : Long.valueOf(cancelledAt.toEpochSecond());
        this.failedAt = failedAt == null ? null : Long.valueOf(failedAt.toEpochSecond());
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public RunStepType getType() {
        return this.type;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getRunId() {
        return this.runId;
    }

    public RunStepStatus getStatus() {
        return this.status;
    }

    public RunStepDetails getStepDetails() {
        return this.stepDetails;
    }

    public RunStepError getLastError() {
        return this.lastError;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getExpiredAt() {
        if (this.expiredAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiredAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCancelledAt() {
        if (this.cancelledAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancelledAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getFailedAt() {
        if (this.failedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.failedAt), ZoneOffset.UTC);
    }

    public RunStepCompletionUsage getUsage() {
        return this.usage;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("thread_id", this.threadId);
        jsonWriter.writeStringField("run_id", this.runId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("step_details", (JsonSerializable)this.stepDetails);
        jsonWriter.writeJsonField("last_error", (JsonSerializable)this.lastError);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeNumberField("expired_at", (Number)this.expiredAt);
        jsonWriter.writeNumberField("completed_at", (Number)this.completedAt);
        jsonWriter.writeNumberField("cancelled_at", (Number)this.cancelledAt);
        jsonWriter.writeNumberField("failed_at", (Number)this.failedAt);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        return jsonWriter.writeEndObject();
    }

    public static RunStep fromJson(JsonReader jsonReader) throws IOException {
        return (RunStep)jsonReader.readObject(reader -> {
            String id = null;
            RunStepType type = null;
            String assistantId = null;
            String threadId = null;
            String runId = null;
            RunStepStatus status = null;
            RunStepDetails stepDetails = null;
            RunStepError lastError = null;
            OffsetDateTime createdAt = null;
            OffsetDateTime expiredAt = null;
            OffsetDateTime completedAt = null;
            OffsetDateTime cancelledAt = null;
            OffsetDateTime failedAt = null;
            Map metadata = null;
            RunStepCompletionUsage usage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = RunStepType.fromString(reader.getString());
                    continue;
                }
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("thread_id".equals(fieldName)) {
                    threadId = reader.getString();
                    continue;
                }
                if ("run_id".equals(fieldName)) {
                    runId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = RunStepStatus.fromString(reader.getString());
                    continue;
                }
                if ("step_details".equals(fieldName)) {
                    stepDetails = RunStepDetails.fromJson(reader);
                    continue;
                }
                if ("last_error".equals(fieldName)) {
                    lastError = RunStepError.fromJson(reader);
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("expired_at".equals(fieldName)) {
                    Long expiredAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (expiredAtHolder == null) continue;
                    expiredAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiredAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("completed_at".equals(fieldName)) {
                    Long completedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (completedAtHolder == null) continue;
                    completedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(completedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("cancelled_at".equals(fieldName)) {
                    Long cancelledAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (cancelledAtHolder == null) continue;
                    cancelledAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(cancelledAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("failed_at".equals(fieldName)) {
                    Long failedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (failedAtHolder == null) continue;
                    failedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(failedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = RunStepCompletionUsage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            RunStep deserializedRunStep = new RunStep(id, type, assistantId, threadId, runId, status, stepDetails, lastError, createdAt, expiredAt, completedAt, cancelledAt, failedAt, metadata);
            deserializedRunStep.usage = usage;
            return deserializedRunStep;
        });
    }
}

