/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepDeltaFunction;
import com.azure.ai.agents.persistent.models.RunStepDeltaToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepDeltaFunctionToolCall
extends RunStepDeltaToolCall {
    private String type = "function";
    private RunStepDeltaFunction function;

    private RunStepDeltaFunctionToolCall(int index, String id) {
        super(index, id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public RunStepDeltaFunction getFunction() {
        return this.function;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        return jsonWriter.writeEndObject();
    }

    public static RunStepDeltaFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepDeltaFunctionToolCall)jsonReader.readObject(reader -> {
            int index = 0;
            String id = null;
            String type = "function";
            RunStepDeltaFunction function = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    function = RunStepDeltaFunction.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            RunStepDeltaFunctionToolCall deserializedRunStepDeltaFunctionToolCall = new RunStepDeltaFunctionToolCall(index, id);
            deserializedRunStepDeltaFunctionToolCall.type = type;
            deserializedRunStepDeltaFunctionToolCall.function = function;
            return deserializedRunStepDeltaFunctionToolCall;
        });
    }
}

