/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.FileSearchToolCallContent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RunStepFileSearchToolCallResult
implements JsonSerializable<RunStepFileSearchToolCallResult> {
    private final String fileId;
    private final String fileName;
    private final double score;
    private List<FileSearchToolCallContent> content;

    private RunStepFileSearchToolCallResult(String fileId, String fileName, double score) {
        this.fileId = fileId;
        this.fileName = fileName;
        this.score = score;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public double getScore() {
        return this.score;
    }

    public List<FileSearchToolCallContent> getContent() {
        return this.content;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("file_name", this.fileName);
        jsonWriter.writeDoubleField("score", this.score);
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunStepFileSearchToolCallResult fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepFileSearchToolCallResult)jsonReader.readObject(reader -> {
            String fileId = null;
            String fileName = null;
            double score = 0.0;
            List content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("file_name".equals(fieldName)) {
                    fileName = reader.getString();
                    continue;
                }
                if ("score".equals(fieldName)) {
                    score = reader.getDouble();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> FileSearchToolCallContent.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            RunStepFileSearchToolCallResult deserializedRunStepFileSearchToolCallResult = new RunStepFileSearchToolCallResult(fileId, fileName, score);
            deserializedRunStepFileSearchToolCallResult.content = content;
            return deserializedRunStepFileSearchToolCallResult;
        });
    }
}

