/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunStepSharepointToolCall
extends RunStepToolCall {
    private String type = "sharepoint_grounding";
    private final Map<String, String> sharePoint;

    private RunStepSharepointToolCall(String id, Map<String, String> sharePoint) {
        super(id);
        this.sharePoint = sharePoint;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Map<String, String> getSharePoint() {
        return this.sharePoint;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeMapField("sharepoint_grounding", this.sharePoint, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepSharepointToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepSharepointToolCall)jsonReader.readObject(reader -> {
            String id = null;
            Map sharePoint = null;
            String type = "sharepoint_grounding";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("sharepoint_grounding".equals(fieldName)) {
                    sharePoint = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepSharepointToolCall deserializedRunStepSharepointToolCall = new RunStepSharepointToolCall(id, sharePoint);
            deserializedRunStepSharepointToolCall.type = type;
            return deserializedRunStepSharepointToolCall;
        });
    }
}

