/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepAzureAISearchToolCall;
import com.azure.ai.agents.persistent.models.RunStepBingCustomSearchToolCall;
import com.azure.ai.agents.persistent.models.RunStepBingGroundingToolCall;
import com.azure.ai.agents.persistent.models.RunStepCodeInterpreterToolCall;
import com.azure.ai.agents.persistent.models.RunStepFileSearchToolCall;
import com.azure.ai.agents.persistent.models.RunStepFunctionToolCall;
import com.azure.ai.agents.persistent.models.RunStepMicrosoftFabricToolCall;
import com.azure.ai.agents.persistent.models.RunStepOpenApiToolCall;
import com.azure.ai.agents.persistent.models.RunStepSharepointToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class RunStepToolCall
implements JsonSerializable<RunStepToolCall> {
    private String type = "RunStepToolCall";
    private final String id;

    protected RunStepToolCall(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepToolCall)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RunStepToolCall runStepToolCall;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("code_interpreter".equals(discriminatorValue)) {
                    runStepToolCall = RunStepCodeInterpreterToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("file_search".equals(discriminatorValue)) {
                    runStepToolCall = RunStepFileSearchToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("bing_grounding".equals(discriminatorValue)) {
                    runStepToolCall = RunStepBingGroundingToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("azure_ai_search".equals(discriminatorValue)) {
                    runStepToolCall = RunStepAzureAISearchToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("sharepoint_grounding".equals(discriminatorValue)) {
                    runStepToolCall = RunStepSharepointToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("fabric_dataagent".equals(discriminatorValue)) {
                    runStepToolCall = RunStepMicrosoftFabricToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("bing_custom_search".equals(discriminatorValue)) {
                    runStepToolCall = RunStepBingCustomSearchToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("function".equals(discriminatorValue)) {
                    runStepToolCall = RunStepFunctionToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("openapi".equals(discriminatorValue)) {
                    runStepToolCall = RunStepOpenApiToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                runStepToolCall = RunStepToolCall.fromJsonKnownDiscriminator(readerToUse.reset());
                return runStepToolCall;
            }
        });
    }

    static RunStepToolCall fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RunStepToolCall)jsonReader.readObject(reader -> {
            String id = null;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepToolCall deserializedRunStepToolCall = new RunStepToolCall(id);
            deserializedRunStepToolCall.type = type;
            return deserializedRunStepToolCall;
        });
    }
}

