/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaChunk;
import com.azure.ai.agents.persistent.models.PersistentAgentStreamEvent;
import com.azure.ai.agents.persistent.models.RunStep;
import com.azure.ai.agents.persistent.models.RunStepDeltaChunk;
import com.azure.ai.agents.persistent.models.StreamMessageCreation;
import com.azure.ai.agents.persistent.models.StreamMessageUpdate;
import com.azure.ai.agents.persistent.models.StreamRequiredAction;
import com.azure.ai.agents.persistent.models.StreamRunCreation;
import com.azure.ai.agents.persistent.models.StreamRunStepUpdate;
import com.azure.ai.agents.persistent.models.StreamThreadCreation;
import com.azure.ai.agents.persistent.models.StreamThreadRunCreation;
import com.azure.ai.agents.persistent.models.StreamUpdate;
import com.azure.ai.agents.persistent.models.ThreadMessage;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;

public final class StreamTypeFactory {
    private final ClientLogger logger = new ClientLogger(StreamTypeFactory.class);

    public StreamUpdate deserializeEvent(String eventName, BinaryData eventJson) throws IllegalArgumentException {
        PersistentAgentStreamEvent event = PersistentAgentStreamEvent.fromString(eventName);
        if (PersistentAgentStreamEvent.THREAD_CREATED.equals((Object)event)) {
            return new StreamThreadCreation((PersistentAgentStreamEvent)((Object)eventJson.toObject(PersistentAgentStreamEvent.class)), event);
        }
        if (PersistentAgentStreamEvent.THREAD_RUN_CREATED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_QUEUED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_IN_PROGRESS.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_COMPLETED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_CANCELLED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_CANCELLING.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_FAILED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_EXPIRED.equals((Object)event)) {
            return new StreamThreadRunCreation((ThreadRun)eventJson.toObject(ThreadRun.class), event);
        }
        if (PersistentAgentStreamEvent.THREAD_RUN_STEP_CREATED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_STEP_IN_PROGRESS.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_STEP_COMPLETED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_STEP_FAILED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_STEP_CANCELLED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_RUN_STEP_EXPIRED.equals((Object)event)) {
            return new StreamRunCreation((RunStep)eventJson.toObject(RunStep.class), event);
        }
        if (PersistentAgentStreamEvent.THREAD_MESSAGE_CREATED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_MESSAGE_IN_PROGRESS.equals((Object)event) || PersistentAgentStreamEvent.THREAD_MESSAGE_COMPLETED.equals((Object)event) || PersistentAgentStreamEvent.THREAD_MESSAGE_INCOMPLETE.equals((Object)event)) {
            return new StreamMessageCreation((ThreadMessage)eventJson.toObject(ThreadMessage.class), event);
        }
        if (PersistentAgentStreamEvent.THREAD_MESSAGE_DELTA.equals((Object)event)) {
            return new StreamMessageUpdate((MessageDeltaChunk)eventJson.toObject(MessageDeltaChunk.class), event);
        }
        if (PersistentAgentStreamEvent.THREAD_RUN_STEP_DELTA.equals((Object)event)) {
            return new StreamRunStepUpdate((RunStepDeltaChunk)eventJson.toObject(RunStepDeltaChunk.class), event);
        }
        if (PersistentAgentStreamEvent.THREAD_RUN_REQUIRES_ACTION.equals((Object)event)) {
            return new StreamRequiredAction((ThreadRun)eventJson.toObject(ThreadRun.class), event);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown event type: " + (Object)((Object)event)));
    }
}

