/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageAttachment;
import com.azure.ai.agents.persistent.models.MessageRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ThreadMessageOptions
implements JsonSerializable<ThreadMessageOptions> {
    private final MessageRole role;
    private final BinaryData content;
    private List<MessageAttachment> attachments;
    private Map<String, String> metadata;

    public ThreadMessageOptions(MessageRole role, BinaryData content) {
        this.role = role;
        this.content = content;
    }

    public MessageRole getRole() {
        return this.role;
    }

    public BinaryData getContent() {
        return this.content;
    }

    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    public ThreadMessageOptions setAttachments(List<MessageAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ThreadMessageOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ThreadMessageOptions fromJson(JsonReader jsonReader) throws IOException {
        return (ThreadMessageOptions)jsonReader.readObject(reader -> {
            MessageRole role = null;
            BinaryData content = null;
            List attachments = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> MessageAttachment.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ThreadMessageOptions deserializedThreadMessageOptions = new ThreadMessageOptions(role, content);
            deserializedThreadMessageOptions.attachments = attachments;
            deserializedThreadMessageOptions.metadata = metadata;
            return deserializedThreadMessageOptions;
        });
    }
}

