/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.AzureAISearchToolDefinition;
import com.azure.ai.agents.persistent.models.AzureFunctionToolDefinition;
import com.azure.ai.agents.persistent.models.BingCustomSearchToolDefinition;
import com.azure.ai.agents.persistent.models.BingGroundingToolDefinition;
import com.azure.ai.agents.persistent.models.CodeInterpreterToolDefinition;
import com.azure.ai.agents.persistent.models.ConnectedAgentToolDefinition;
import com.azure.ai.agents.persistent.models.FileSearchToolDefinition;
import com.azure.ai.agents.persistent.models.FunctionToolDefinition;
import com.azure.ai.agents.persistent.models.MicrosoftFabricToolDefinition;
import com.azure.ai.agents.persistent.models.OpenApiToolDefinition;
import com.azure.ai.agents.persistent.models.SharepointToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ToolDefinition
implements JsonSerializable<ToolDefinition> {
    private String type = "ToolDefinition";

    public String getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ToolDefinition)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ToolDefinition toolDefinition;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("file_search".equals(discriminatorValue)) {
                    toolDefinition = FileSearchToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("function".equals(discriminatorValue)) {
                    toolDefinition = FunctionToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("bing_grounding".equals(discriminatorValue)) {
                    toolDefinition = BingGroundingToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("fabric_dataagent".equals(discriminatorValue)) {
                    toolDefinition = MicrosoftFabricToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("sharepoint_grounding".equals(discriminatorValue)) {
                    toolDefinition = SharepointToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("azure_ai_search".equals(discriminatorValue)) {
                    toolDefinition = AzureAISearchToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("openapi".equals(discriminatorValue)) {
                    toolDefinition = OpenApiToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("bing_custom_search".equals(discriminatorValue)) {
                    toolDefinition = BingCustomSearchToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("connected_agent".equals(discriminatorValue)) {
                    toolDefinition = ConnectedAgentToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("azure_function".equals(discriminatorValue)) {
                    toolDefinition = AzureFunctionToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("code_interpreter".equals(discriminatorValue)) {
                    toolDefinition = CodeInterpreterToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                toolDefinition = ToolDefinition.fromJsonKnownDiscriminator(readerToUse.reset());
                return toolDefinition;
            }
        });
    }

    static ToolDefinition fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ToolDefinition)jsonReader.readObject(reader -> {
            ToolDefinition deserializedToolDefinition = new ToolDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedToolDefinition.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedToolDefinition;
        });
    }
}

