/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicyAnchor;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreExpirationPolicy
implements JsonSerializable<VectorStoreExpirationPolicy> {
    private final VectorStoreExpirationPolicyAnchor anchor;
    private final int days;

    public VectorStoreExpirationPolicy(VectorStoreExpirationPolicyAnchor anchor, int days) {
        this.anchor = anchor;
        this.days = days;
    }

    public VectorStoreExpirationPolicyAnchor getAnchor() {
        return this.anchor;
    }

    public int getDays() {
        return this.days;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("anchor", this.anchor == null ? null : this.anchor.toString());
        jsonWriter.writeIntField("days", this.days);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreExpirationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreExpirationPolicy)jsonReader.readObject(reader -> {
            VectorStoreExpirationPolicyAnchor anchor = null;
            int days = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("anchor".equals(fieldName)) {
                    anchor = VectorStoreExpirationPolicyAnchor.fromString(reader.getString());
                    continue;
                }
                if ("days".equals(fieldName)) {
                    days = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreExpirationPolicy(anchor, days);
        });
    }
}

