/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreStaticChunkingStrategyOptions
implements JsonSerializable<VectorStoreStaticChunkingStrategyOptions> {
    private final int maxChunkSizeTokens;
    private final int chunkOverlapTokens;

    public VectorStoreStaticChunkingStrategyOptions(int maxChunkSizeTokens, int chunkOverlapTokens) {
        this.maxChunkSizeTokens = maxChunkSizeTokens;
        this.chunkOverlapTokens = chunkOverlapTokens;
    }

    public int getMaxChunkSizeTokens() {
        return this.maxChunkSizeTokens;
    }

    public int getChunkOverlapTokens() {
        return this.chunkOverlapTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("max_chunk_size_tokens", this.maxChunkSizeTokens);
        jsonWriter.writeIntField("chunk_overlap_tokens", this.chunkOverlapTokens);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreStaticChunkingStrategyOptions fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreStaticChunkingStrategyOptions)jsonReader.readObject(reader -> {
            int maxChunkSizeTokens = 0;
            int chunkOverlapTokens = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("max_chunk_size_tokens".equals(fieldName)) {
                    maxChunkSizeTokens = reader.getInt();
                    continue;
                }
                if ("chunk_overlap_tokens".equals(fieldName)) {
                    chunkOverlapTokens = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreStaticChunkingStrategyOptions(maxChunkSizeTokens, chunkOverlapTokens);
        });
    }
}

