// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.implementation;

import com.azure.ai.anomalydetector.AnomalyDetectorServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the AnomalyDetectorClient type. */
public final class AnomalyDetectorClientImpl {
    /** The proxy service used to perform REST calls. */
    private final AnomalyDetectorClientService service;

    /**
     * Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     */
    private final String endpoint;

    /**
     * Gets Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Service version. */
    private final AnomalyDetectorServiceVersion serviceVersion;

    /**
     * Gets Service version.
     *
     * @return the serviceVersion value.
     */
    public AnomalyDetectorServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of AnomalyDetectorClient client.
     *
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param serviceVersion Service version.
     */
    public AnomalyDetectorClientImpl(String endpoint, AnomalyDetectorServiceVersion serviceVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                endpoint,
                serviceVersion);
    }

    /**
     * Initializes an instance of AnomalyDetectorClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param serviceVersion Service version.
     */
    public AnomalyDetectorClientImpl(
            HttpPipeline httpPipeline, String endpoint, AnomalyDetectorServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of AnomalyDetectorClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param serviceVersion Service version.
     */
    public AnomalyDetectorClientImpl(
            HttpPipeline httpPipeline,
            SerializerAdapter serializerAdapter,
            String endpoint,
            AnomalyDetectorServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service =
                RestProxy.create(AnomalyDetectorClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for AnomalyDetectorClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{Endpoint}/anomalydetector/{ApiVersion}")
    @ServiceInterface(name = "AnomalyDetectorClien")
    public interface AnomalyDetectorClientService {
        @Post("/timeseries/entire/detect")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> detectUnivariateEntireSeries(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData options,
                RequestOptions requestOptions,
                Context context);

        @Post("/timeseries/last/detect")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> detectUnivariateLastPoint(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData options,
                RequestOptions requestOptions,
                Context context);

        @Post("/timeseries/changepoint/detect")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> detectUnivariateChangePoint(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData options,
                RequestOptions requestOptions,
                Context context);

        @Get("/multivariate/detect-batch/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getMultivariateBatchDetectionResult(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") String resultId,
                @HeaderParam("accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post("/multivariate/models")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> trainMultivariateModel(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData modelInfo,
                RequestOptions requestOptions,
                Context context);

        @Get("/multivariate/models")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listMultivariateModels(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete("/multivariate/models/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteMultivariateModel(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") String modelId,
                @HeaderParam("accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/multivariate/models/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getMultivariateModel(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") String modelId,
                @HeaderParam("accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post("/multivariate/models/{modelId}:detect-batch")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> detectMultivariateBatchAnomaly(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") String modelId,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData options,
                RequestOptions requestOptions,
                Context context);

        @Post("/multivariate/models/{modelId}:detect-last")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> detectMultivariateLastAnomaly(
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") String modelId,
                @HeaderParam("accept") String accept,
                @BodyParam("application/json") BinaryData options,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listMultivariateModelsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("Endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("accept") String accept,
                RequestOptions requestOptions,
                Context context);
    }

    /**
     * Detect anomalies for the entire series in batch.
     *
     * <p>This operation generates a model with an entire series, each point is detected with the same model. With this
     * method, points before and after a certain point are used to determine whether it is an anomaly. The entire
     * detection can give user an overall status of the time series.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Optional)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     maxAnomalyRatio: Double (Optional)
     *     sensitivity: Integer (Optional)
     *     imputeMode: String(auto/previous/linear/fixed/zero/notFill) (Optional)
     *     imputeFixedValue: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: int (Required)
     *     expectedValues (Required): [
     *         double (Required)
     *     ]
     *     upperMargins (Required): [
     *         double (Required)
     *     ]
     *     lowerMargins (Required): [
     *         double (Required)
     *     ]
     *     isAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     isNegativeAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     isPositiveAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     severity (Optional): [
     *         double (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of entire anomaly detection along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateEntireSeriesWithResponseAsync(
            BinaryData options, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.detectUnivariateEntireSeries(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                accept,
                                options,
                                requestOptions,
                                context));
    }

    /**
     * Detect anomalies for the entire series in batch.
     *
     * <p>This operation generates a model with an entire series, each point is detected with the same model. With this
     * method, points before and after a certain point are used to determine whether it is an anomaly. The entire
     * detection can give user an overall status of the time series.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Optional)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     maxAnomalyRatio: Double (Optional)
     *     sensitivity: Integer (Optional)
     *     imputeMode: String(auto/previous/linear/fixed/zero/notFill) (Optional)
     *     imputeFixedValue: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: int (Required)
     *     expectedValues (Required): [
     *         double (Required)
     *     ]
     *     upperMargins (Required): [
     *         double (Required)
     *     ]
     *     lowerMargins (Required): [
     *         double (Required)
     *     ]
     *     isAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     isNegativeAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     isPositiveAnomaly (Required): [
     *         boolean (Required)
     *     ]
     *     severity (Optional): [
     *         double (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of entire anomaly detection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateEntireSeriesWithResponse(
            BinaryData options, RequestOptions requestOptions) {
        return detectUnivariateEntireSeriesWithResponseAsync(options, requestOptions).block();
    }

    /**
     * Detect anomaly status of the latest point in time series.
     *
     * <p>This operation generates a model using the points that you sent into the API, and based on all data to
     * determine whether the last point is anomalous.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Optional)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     maxAnomalyRatio: Double (Optional)
     *     sensitivity: Integer (Optional)
     *     imputeMode: String(auto/previous/linear/fixed/zero/notFill) (Optional)
     *     imputeFixedValue: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: int (Required)
     *     suggestedWindow: int (Required)
     *     expectedValue: double (Required)
     *     upperMargin: double (Required)
     *     lowerMargin: double (Required)
     *     isAnomaly: boolean (Required)
     *     isNegativeAnomaly: boolean (Required)
     *     isPositiveAnomaly: boolean (Required)
     *     severity: Double (Optional)
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of last anomaly detection along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateLastPointWithResponseAsync(
            BinaryData options, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.detectUnivariateLastPoint(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                accept,
                                options,
                                requestOptions,
                                context));
    }

    /**
     * Detect anomaly status of the latest point in time series.
     *
     * <p>This operation generates a model using the points that you sent into the API, and based on all data to
     * determine whether the last point is anomalous.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Optional)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     maxAnomalyRatio: Double (Optional)
     *     sensitivity: Integer (Optional)
     *     imputeMode: String(auto/previous/linear/fixed/zero/notFill) (Optional)
     *     imputeFixedValue: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: int (Required)
     *     suggestedWindow: int (Required)
     *     expectedValue: double (Required)
     *     upperMargin: double (Required)
     *     lowerMargin: double (Required)
     *     isAnomaly: boolean (Required)
     *     isNegativeAnomaly: boolean (Required)
     *     isPositiveAnomaly: boolean (Required)
     *     severity: Double (Optional)
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of last anomaly detection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateLastPointWithResponse(
            BinaryData options, RequestOptions requestOptions) {
        return detectUnivariateLastPointWithResponseAsync(options, requestOptions).block();
    }

    /**
     * Detect change point for the entire series
     *
     * <p>Evaluate change point score of every series point.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Required)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     stableTrendWindow: Integer (Optional)
     *     threshold: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: Integer (Optional)
     *     isChangePoint (Optional): [
     *         boolean (Optional)
     *     ]
     *     confidenceScores (Optional): [
     *         double (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of change point detection along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateChangePointWithResponseAsync(
            BinaryData options, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.detectUnivariateChangePoint(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                accept,
                                options,
                                requestOptions,
                                context));
    }

    /**
     * Detect change point for the entire series
     *
     * <p>Evaluate change point score of every series point.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     series (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Optional)
     *             value: double (Required)
     *         }
     *     ]
     *     granularity: String(yearly/monthly/weekly/daily/hourly/minutely/secondly/microsecond/none) (Required)
     *     customInterval: Integer (Optional)
     *     period: Integer (Optional)
     *     stableTrendWindow: Integer (Optional)
     *     threshold: Double (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     period: Integer (Optional)
     *     isChangePoint (Optional): [
     *         boolean (Optional)
     *     ]
     *     confidenceScores (Optional): [
     *         double (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param options Method of univariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response of change point detection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateChangePointWithResponse(
            BinaryData options, RequestOptions requestOptions) {
        return detectUnivariateChangePointWithResponseAsync(options, requestOptions).block();
    }

    /**
     * Get Multivariate Anomaly Detection Result
     *
     * <p>For asynchronous inference, get multivariate anomaly detection result based on resultId returned by the
     * BatchDetectAnomaly api.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     resultId: String (Required)
     *     summary (Required): {
     *         status: String(CREATED/RUNNING/READY/FAILED) (Required)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *         setupInfo (Required): {
     *             dataSource: String (Required)
     *             topContributorCount: int (Required)
     *             startTime: OffsetDateTime (Required)
     *             endTime: OffsetDateTime (Required)
     *         }
     *     }
     *     results (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param resultId ID of a batch detection result.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detection results for the given resultId along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateBatchDetectionResultWithResponseAsync(
            String resultId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getMultivariateBatchDetectionResult(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                resultId,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get Multivariate Anomaly Detection Result
     *
     * <p>For asynchronous inference, get multivariate anomaly detection result based on resultId returned by the
     * BatchDetectAnomaly api.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     resultId: String (Required)
     *     summary (Required): {
     *         status: String(CREATED/RUNNING/READY/FAILED) (Required)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *         setupInfo (Required): {
     *             dataSource: String (Required)
     *             topContributorCount: int (Required)
     *             startTime: OffsetDateTime (Required)
     *             endTime: OffsetDateTime (Required)
     *         }
     *     }
     *     results (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param resultId ID of a batch detection result.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detection results for the given resultId along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateBatchDetectionResultWithResponse(
            String resultId, RequestOptions requestOptions) {
        return getMultivariateBatchDetectionResultWithResponseAsync(resultId, requestOptions).block();
    }

    /**
     * Train a Multivariate Anomaly Detection Model
     *
     * <p>Create and train a multivariate anomaly detection model. The request must include a source parameter to
     * indicate an externally accessible Azure blob storage URI.There are two types of data input: An URI pointed to an
     * Azure blob storage folder which contains multiple CSV files, and each CSV file contains two columns, timestamp
     * and variable. Another type of input is an URI pointed to a CSV file in Azure blob storage, which contains all the
     * variables and a timestamp column.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     dataSource: String (Required)
     *     dataSchema: String(OneTable/MultiTable) (Optional)
     *     startTime: OffsetDateTime (Required)
     *     endTime: OffsetDateTime (Required)
     *     displayName: String (Optional)
     *     slidingWindow: Integer (Optional)
     *     alignPolicy (Optional): {
     *         alignMode: String(Inner/Outer) (Optional)
     *         fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *         paddingValue: Double (Optional)
     *     }
     *     status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *     errors (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *         }
     *     ]
     *     diagnosticsInfo (Optional): {
     *         modelState (Optional): {
     *             epochIds (Optional): [
     *                 int (Optional)
     *             ]
     *             trainLosses (Optional): [
     *                 double (Optional)
     *             ]
     *             validationLosses (Optional): [
     *                 double (Optional)
     *             ]
     *             latenciesInSeconds (Optional): [
     *                 double (Optional)
     *             ]
     *         }
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param modelInfo Model information.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of getting a model along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> trainMultivariateModelWithResponseAsync(
            BinaryData modelInfo, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.trainMultivariateModel(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                accept,
                                modelInfo,
                                requestOptions,
                                context));
    }

    /**
     * Train a Multivariate Anomaly Detection Model
     *
     * <p>Create and train a multivariate anomaly detection model. The request must include a source parameter to
     * indicate an externally accessible Azure blob storage URI.There are two types of data input: An URI pointed to an
     * Azure blob storage folder which contains multiple CSV files, and each CSV file contains two columns, timestamp
     * and variable. Another type of input is an URI pointed to a CSV file in Azure blob storage, which contains all the
     * variables and a timestamp column.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     dataSource: String (Required)
     *     dataSchema: String(OneTable/MultiTable) (Optional)
     *     startTime: OffsetDateTime (Required)
     *     endTime: OffsetDateTime (Required)
     *     displayName: String (Optional)
     *     slidingWindow: Integer (Optional)
     *     alignPolicy (Optional): {
     *         alignMode: String(Inner/Outer) (Optional)
     *         fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *         paddingValue: Double (Optional)
     *     }
     *     status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *     errors (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *         }
     *     ]
     *     diagnosticsInfo (Optional): {
     *         modelState (Optional): {
     *             epochIds (Optional): [
     *                 int (Optional)
     *             ]
     *             trainLosses (Optional): [
     *                 double (Optional)
     *             ]
     *             validationLosses (Optional): [
     *                 double (Optional)
     *             ]
     *             latenciesInSeconds (Optional): [
     *                 double (Optional)
     *             ]
     *         }
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param modelInfo Model information.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of getting a model along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> trainMultivariateModelWithResponse(
            BinaryData modelInfo, RequestOptions requestOptions) {
        return trainMultivariateModelWithResponseAsync(modelInfo, requestOptions).block();
    }

    /**
     * List Multivariate Models
     *
     * <p>List models of a resource.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>skip</td><td>Integer</td><td>No</td><td>Skip indicates how many models will be skipped.</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Top indicates how many models will be fetched.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of listing models along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMultivariateModelsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listMultivariateModels(
                                        this.getEndpoint(),
                                        this.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "models"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * List Multivariate Models
     *
     * <p>List models of a resource.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>skip</td><td>Integer</td><td>No</td><td>Skip indicates how many models will be skipped.</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Top indicates how many models will be fetched.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of listing models as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMultivariateModelsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listMultivariateModelsSinglePageAsync(requestOptions),
                nextLink -> listMultivariateModelsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List Multivariate Models
     *
     * <p>List models of a resource.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>skip</td><td>Integer</td><td>No</td><td>Skip indicates how many models will be skipped.</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Top indicates how many models will be fetched.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of listing models as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMultivariateModels(RequestOptions requestOptions) {
        return new PagedIterable<>(listMultivariateModelsAsync(requestOptions));
    }

    /**
     * Delete Multivariate Model
     *
     * <p>Delete an existing multivariate model according to the modelId.
     *
     * @param modelId Model identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMultivariateModelWithResponseAsync(
            String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteMultivariateModel(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                modelId,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Delete Multivariate Model
     *
     * <p>Delete an existing multivariate model according to the modelId.
     *
     * @param modelId Model identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return deleteMultivariateModelWithResponseAsync(modelId, requestOptions).block();
    }

    /**
     * Get Multivariate Model
     *
     * <p>Get detailed information of multivariate model, including the training status and variables used in the model.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed information of multivariate model, including the training status and variables used in the model
     *     along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateModelWithResponseAsync(
            String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getMultivariateModel(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                modelId,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get Multivariate Model
     *
     * <p>Get detailed information of multivariate model, including the training status and variables used in the model.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed information of multivariate model, including the training status and variables used in the model
     *     along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return getMultivariateModelWithResponseAsync(modelId, requestOptions).block();
    }

    /**
     * Detect Multivariate Anomaly
     *
     * <p>Submit multivariate anomaly detection task with the modelId of trained model and inference data, the input
     * schema should be the same with the training request. The request will complete asynchronously and return a
     * resultId to query the detection result.The request should be a source link to indicate an externally accessible
     * Azure storage Uri, either pointed to an Azure blob storage folder, or pointed to a CSV file in Azure blob
     * storage.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     dataSource: String (Required)
     *     topContributorCount: int (Required)
     *     startTime: OffsetDateTime (Required)
     *     endTime: OffsetDateTime (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     resultId: String (Required)
     *     summary (Required): {
     *         status: String(CREATED/RUNNING/READY/FAILED) (Required)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *         setupInfo (Required): {
     *             dataSource: String (Required)
     *             topContributorCount: int (Required)
     *             startTime: OffsetDateTime (Required)
     *             endTime: OffsetDateTime (Required)
     *         }
     *     }
     *     results (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param options Request of multivariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detection results for the given resultId along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateBatchAnomalyWithResponseAsync(
            String modelId, BinaryData options, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.detectMultivariateBatchAnomaly(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                modelId,
                                accept,
                                options,
                                requestOptions,
                                context));
    }

    /**
     * Detect Multivariate Anomaly
     *
     * <p>Submit multivariate anomaly detection task with the modelId of trained model and inference data, the input
     * schema should be the same with the training request. The request will complete asynchronously and return a
     * resultId to query the detection result.The request should be a source link to indicate an externally accessible
     * Azure storage Uri, either pointed to an Azure blob storage folder, or pointed to a CSV file in Azure blob
     * storage.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     dataSource: String (Required)
     *     topContributorCount: int (Required)
     *     startTime: OffsetDateTime (Required)
     *     endTime: OffsetDateTime (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     resultId: String (Required)
     *     summary (Required): {
     *         status: String(CREATED/RUNNING/READY/FAILED) (Required)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         variableStates (Optional): [
     *              (Optional){
     *                 variable: String (Optional)
     *                 filledNARatio: Double (Optional)
     *                 effectiveCount: Integer (Optional)
     *                 firstTimestamp: OffsetDateTime (Optional)
     *                 lastTimestamp: OffsetDateTime (Optional)
     *             }
     *         ]
     *         setupInfo (Required): {
     *             dataSource: String (Required)
     *             topContributorCount: int (Required)
     *             startTime: OffsetDateTime (Required)
     *             endTime: OffsetDateTime (Required)
     *         }
     *     }
     *     results (Required): [
     *          (Required){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param options Request of multivariate anomaly detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detection results for the given resultId along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateBatchAnomalyWithResponse(
            String modelId, BinaryData options, RequestOptions requestOptions) {
        return detectMultivariateBatchAnomalyWithResponseAsync(modelId, options, requestOptions).block();
    }

    /**
     * Detect anomalies in the last point of the request body
     *
     * <p>Submit multivariate anomaly detection task with the modelId of trained model and inference data, and the
     * inference data should be put into request body in a JSON format. The request will complete synchronously and
     * return the detection immediately in the response body.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     variables (Required): [
     *          (Required){
     *             variable: String (Required)
     *             timestamps (Required): [
     *                 String (Required)
     *             ]
     *             values (Required): [
     *                 double (Required)
     *             ]
     *         }
     *     ]
     *     topContributorCount: int (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     variableStates (Optional): [
     *          (Optional){
     *             variable: String (Optional)
     *             filledNARatio: Double (Optional)
     *             effectiveCount: Integer (Optional)
     *             firstTimestamp: OffsetDateTime (Optional)
     *             lastTimestamp: OffsetDateTime (Optional)
     *         }
     *     ]
     *     results (Optional): [
     *          (Optional){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                  (Optional){
     *                     code: String (Required)
     *                     message: String (Required)
     *                 }
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param options Request of last detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return results of last detection along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateLastAnomalyWithResponseAsync(
            String modelId, BinaryData options, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.detectMultivariateLastAnomaly(
                                this.getEndpoint(),
                                this.getServiceVersion().getVersion(),
                                modelId,
                                accept,
                                options,
                                requestOptions,
                                context));
    }

    /**
     * Detect anomalies in the last point of the request body
     *
     * <p>Submit multivariate anomaly detection task with the modelId of trained model and inference data, and the
     * inference data should be put into request body in a JSON format. The request will complete synchronously and
     * return the detection immediately in the response body.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     variables (Required): [
     *          (Required){
     *             variable: String (Required)
     *             timestamps (Required): [
     *                 String (Required)
     *             ]
     *             values (Required): [
     *                 double (Required)
     *             ]
     *         }
     *     ]
     *     topContributorCount: int (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     variableStates (Optional): [
     *          (Optional){
     *             variable: String (Optional)
     *             filledNARatio: Double (Optional)
     *             effectiveCount: Integer (Optional)
     *             firstTimestamp: OffsetDateTime (Optional)
     *             lastTimestamp: OffsetDateTime (Optional)
     *         }
     *     ]
     *     results (Optional): [
     *          (Optional){
     *             timestamp: OffsetDateTime (Required)
     *             value (Optional): {
     *                 isAnomaly: boolean (Required)
     *                 severity: double (Required)
     *                 score: double (Required)
     *                 interpretation (Optional): [
     *                      (Optional){
     *                         variable: String (Optional)
     *                         contributionScore: Double (Optional)
     *                         correlationChanges (Optional): {
     *                             changedVariables (Optional): [
     *                                 String (Optional)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             errors (Optional): [
     *                  (Optional){
     *                     code: String (Required)
     *                     message: String (Required)
     *                 }
     *             ]
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param modelId Model identifier.
     * @param options Request of last detection.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return results of last detection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateLastAnomalyWithResponse(
            String modelId, BinaryData options, RequestOptions requestOptions) {
        return detectMultivariateLastAnomalyWithResponseAsync(modelId, options, requestOptions).block();
    }

    /**
     * List Multivariate Models
     *
     * <p>Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     modelId: String (Required)
     *     createdTime: OffsetDateTime (Required)
     *     lastUpdatedTime: OffsetDateTime (Required)
     *     modelInfo (Optional): {
     *         dataSource: String (Required)
     *         dataSchema: String(OneTable/MultiTable) (Optional)
     *         startTime: OffsetDateTime (Required)
     *         endTime: OffsetDateTime (Required)
     *         displayName: String (Optional)
     *         slidingWindow: Integer (Optional)
     *         alignPolicy (Optional): {
     *             alignMode: String(Inner/Outer) (Optional)
     *             fillNAMethod: String(Previous/Subsequent/Linear/Zero/Fixed) (Optional)
     *             paddingValue: Double (Optional)
     *         }
     *         status: String(CREATED/RUNNING/READY/FAILED) (Optional)
     *         errors (Optional): [
     *              (Optional){
     *                 code: String (Required)
     *                 message: String (Required)
     *             }
     *         ]
     *         diagnosticsInfo (Optional): {
     *             modelState (Optional): {
     *                 epochIds (Optional): [
     *                     int (Optional)
     *                 ]
     *                 trainLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 validationLosses (Optional): [
     *                     double (Optional)
     *                 ]
     *                 latenciesInSeconds (Optional): [
     *                     double (Optional)
     *                 ]
     *             }
     *             variableStates (Optional): [
     *                  (Optional){
     *                     variable: String (Optional)
     *                     filledNARatio: Double (Optional)
     *                     effectiveCount: Integer (Optional)
     *                     firstTimestamp: OffsetDateTime (Optional)
     *                     lastTimestamp: OffsetDateTime (Optional)
     *                 }
     *             ]
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response of listing models along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMultivariateModelsNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listMultivariateModelsNext(
                                        nextLink,
                                        this.getEndpoint(),
                                        this.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "models"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
