// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.implementation.models;

import com.azure.ai.anomalydetector.models.AnomalyDetectionModel;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response of listing models. */
@Immutable
public final class ModelList {
    /*
     * List of models.
     */
    @JsonProperty(value = "models", required = true)
    private List<AnomalyDetectionModel> models;

    /*
     * Number of trained multivariate models.
     */
    @JsonProperty(value = "currentCount", required = true)
    private int currentCount;

    /*
     * Maximum number of models that can be trained for this Anomaly Detector resource.
     */
    @JsonProperty(value = "maxCount", required = true)
    private int maxCount;

    /*
     * The link to fetch more models.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of ModelList class.
     *
     * @param models the models value to set.
     * @param currentCount the currentCount value to set.
     * @param maxCount the maxCount value to set.
     */
    @JsonCreator
    private ModelList(
            @JsonProperty(value = "models", required = true) List<AnomalyDetectionModel> models,
            @JsonProperty(value = "currentCount", required = true) int currentCount,
            @JsonProperty(value = "maxCount", required = true) int maxCount) {
        this.models = models;
        this.currentCount = currentCount;
        this.maxCount = maxCount;
    }

    /**
     * Get the models property: List of models.
     *
     * @return the models value.
     */
    public List<AnomalyDetectionModel> getModels() {
        return this.models;
    }

    /**
     * Get the currentCount property: Number of trained multivariate models.
     *
     * @return the currentCount value.
     */
    public int getCurrentCount() {
        return this.currentCount;
    }

    /**
     * Get the maxCount property: Maximum number of models that can be trained for this Anomaly Detector resource.
     *
     * @return the maxCount value.
     */
    public int getMaxCount() {
        return this.maxCount;
    }

    /**
     * Get the nextLink property: The link to fetch more models.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
