// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Response of getting a model. */
@Immutable
public final class AnomalyDetectionModel {
    /*
     * Model identifier.
     */
    @JsonProperty(value = "modelId", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String modelId;

    /*
     * Date and time (UTC) when the model was created.
     */
    @JsonProperty(value = "createdTime", required = true)
    private OffsetDateTime createdTime;

    /*
     * Date and time (UTC) when the model was last updated.
     */
    @JsonProperty(value = "lastUpdatedTime", required = true)
    private OffsetDateTime lastUpdatedTime;

    /*
     * Training result of a model including its status, errors and diagnostics
     * information.
     */
    @JsonProperty(value = "modelInfo")
    private ModelInfo modelInfo;

    /**
     * Creates an instance of AnomalyDetectionModel class.
     *
     * @param createdTime the createdTime value to set.
     * @param lastUpdatedTime the lastUpdatedTime value to set.
     */
    @JsonCreator
    private AnomalyDetectionModel(
            @JsonProperty(value = "createdTime", required = true) OffsetDateTime createdTime,
            @JsonProperty(value = "lastUpdatedTime", required = true) OffsetDateTime lastUpdatedTime) {
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    /**
     * Get the modelId property: Model identifier.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the createdTime property: Date and time (UTC) when the model was created.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    /**
     * Get the lastUpdatedTime property: Date and time (UTC) when the model was last updated.
     *
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * Get the modelInfo property: Training result of a model including its status, errors and diagnostics information.
     *
     * @return the modelInfo value.
     */
    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }
}
