// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Interpretation of the anomalous timestamp. */
@Immutable
public final class AnomalyInterpretation {
    /*
     * Variable.
     */
    @JsonProperty(value = "variable")
    private String variable;

    /*
     * This score shows the percentage contributing to the anomalous timestamp. A
     * number between 0 and 1.
     */
    @JsonProperty(value = "contributionScore")
    private Double contributionScore;

    /*
     * Correlation changes among the anomalous variables
     */
    @JsonProperty(value = "correlationChanges")
    private CorrelationChanges correlationChanges;

    /** Creates an instance of AnomalyInterpretation class. */
    private AnomalyInterpretation() {}

    /**
     * Get the variable property: Variable.
     *
     * @return the variable value.
     */
    public String getVariable() {
        return this.variable;
    }

    /**
     * Get the contributionScore property: This score shows the percentage contributing to the anomalous timestamp. A
     * number between 0 and 1.
     *
     * @return the contributionScore value.
     */
    public Double getContributionScore() {
        return this.contributionScore;
    }

    /**
     * Get the correlationChanges property: Correlation changes among the anomalous variables.
     *
     * @return the correlationChanges value.
     */
    public CorrelationChanges getCorrelationChanges() {
        return this.correlationChanges;
    }
}
