// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Anomaly status and information. */
@Immutable
public final class AnomalyState {
    /*
     * The timestamp for this anomaly.
     */
    @JsonProperty(value = "timestamp", required = true)
    private OffsetDateTime timestamp;

    /*
     * The detailed value of this anomalous timestamp.
     */
    @JsonProperty(value = "value")
    private AnomalyValue value;

    /*
     * Error message for the current timestamp.
     */
    @JsonProperty(value = "errors")
    private List<ErrorResponse> errors;

    /**
     * Creates an instance of AnomalyState class.
     *
     * @param timestamp the timestamp value to set.
     */
    @JsonCreator
    private AnomalyState(@JsonProperty(value = "timestamp", required = true) OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * Get the timestamp property: The timestamp for this anomaly.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Get the value property: The detailed value of this anomalous timestamp.
     *
     * @return the value value.
     */
    public AnomalyValue getValue() {
        return this.value;
    }

    /**
     * Get the errors property: Error message for the current timestamp.
     *
     * @return the errors value.
     */
    public List<ErrorResponse> getErrors() {
        return this.errors;
    }
}
