// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Detailed information of the anomalous timestamp. */
@Immutable
public final class AnomalyValue {
    /*
     * True if an anomaly is detected at the current timestamp.
     */
    @JsonProperty(value = "isAnomaly", required = true)
    private boolean isAnomaly;

    /*
     * Indicates the significance of the anomaly. The higher the severity, the more
     * significant the anomaly is.
     */
    @JsonProperty(value = "severity", required = true)
    private double severity;

    /*
     * Raw anomaly score of severity, will help indicate the degree of abnormality as
     * well.
     */
    @JsonProperty(value = "score", required = true)
    private double score;

    /*
     * Interpretation of this anomalous timestamp.
     */
    @JsonProperty(value = "interpretation")
    private List<AnomalyInterpretation> interpretation;

    /**
     * Creates an instance of AnomalyValue class.
     *
     * @param isAnomaly the isAnomaly value to set.
     * @param severity the severity value to set.
     * @param score the score value to set.
     */
    @JsonCreator
    private AnomalyValue(
            @JsonProperty(value = "isAnomaly", required = true) boolean isAnomaly,
            @JsonProperty(value = "severity", required = true) double severity,
            @JsonProperty(value = "score", required = true) double score) {
        this.isAnomaly = isAnomaly;
        this.severity = severity;
        this.score = score;
    }

    /**
     * Get the isAnomaly property: True if an anomaly is detected at the current timestamp.
     *
     * @return the isAnomaly value.
     */
    public boolean isAnomaly() {
        return this.isAnomaly;
    }

    /**
     * Get the severity property: Indicates the significance of the anomaly. The higher the severity, the more
     * significant the anomaly is.
     *
     * @return the severity value.
     */
    public double getSeverity() {
        return this.severity;
    }

    /**
     * Get the score property: Raw anomaly score of severity, will help indicate the degree of abnormality as well.
     *
     * @return the score value.
     */
    public double getScore() {
        return this.score;
    }

    /**
     * Get the interpretation property: Interpretation of this anomalous timestamp.
     *
     * @return the interpretation value.
     */
    public List<AnomalyInterpretation> getInterpretation() {
        return this.interpretation;
    }
}
