// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DataSchema. */
public final class DataSchema extends ExpandableStringEnum<DataSchema> {
    /** Static value OneTable for DataSchema. */
    public static final DataSchema ONE_TABLE = fromString("OneTable");

    /** Static value MultiTable for DataSchema. */
    public static final DataSchema MULTI_TABLE = fromString("MultiTable");

    /**
     * Creates or finds a DataSchema from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DataSchema.
     */
    @JsonCreator
    public static DataSchema fromString(String name) {
        return fromString(name, DataSchema.class);
    }

    /**
     * Gets known DataSchema values.
     *
     * @return known DataSchema values.
     */
    public static Collection<DataSchema> values() {
        return values(DataSchema.class);
    }
}
