// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Diagnostics information to help inspect the states of model or variable. */
@Fluent
public final class DiagnosticsInfo {
    /*
     * Model status.
     */
    @JsonProperty(value = "modelState")
    private ModelState modelState;

    /*
     * Variable Status.
     */
    @JsonProperty(value = "variableStates")
    private List<VariableState> variableStates;

    /** Creates an instance of DiagnosticsInfo class. */
    public DiagnosticsInfo() {}

    /**
     * Get the modelState property: Model status.
     *
     * @return the modelState value.
     */
    public ModelState getModelState() {
        return this.modelState;
    }

    /**
     * Set the modelState property: Model status.
     *
     * @param modelState the modelState value to set.
     * @return the DiagnosticsInfo object itself.
     */
    public DiagnosticsInfo setModelState(ModelState modelState) {
        this.modelState = modelState;
        return this;
    }

    /**
     * Get the variableStates property: Variable Status.
     *
     * @return the variableStates value.
     */
    public List<VariableState> getVariableStates() {
        return this.variableStates;
    }

    /**
     * Set the variableStates property: Variable Status.
     *
     * @param variableStates the variableStates value to set.
     * @return the DiagnosticsInfo object itself.
     */
    public DiagnosticsInfo setVariableStates(List<VariableState> variableStates) {
        this.variableStates = variableStates;
        return this;
    }
}
