// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** ErrorResponse contains code and message that shows the error information. */
@Immutable
public final class ErrorResponse {
    /*
     * The error code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /*
     * The message explaining the error reported by the service.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /**
     * Creates an instance of ErrorResponse class.
     *
     * @param code the code value to set.
     * @param message the message value to set.
     */
    @JsonCreator
    public ErrorResponse(
            @JsonProperty(value = "code", required = true) String code,
            @JsonProperty(value = "message", required = true) String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * Get the code property: The error code.
     *
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: The message explaining the error reported by the service.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }
}
