// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for FillNAMethod. */
public final class FillNAMethod extends ExpandableStringEnum<FillNAMethod> {
    /** Static value Previous for FillNAMethod. */
    public static final FillNAMethod PREVIOUS = fromString("Previous");

    /** Static value Subsequent for FillNAMethod. */
    public static final FillNAMethod SUBSEQUENT = fromString("Subsequent");

    /** Static value Linear for FillNAMethod. */
    public static final FillNAMethod LINEAR = fromString("Linear");

    /** Static value Zero for FillNAMethod. */
    public static final FillNAMethod ZERO = fromString("Zero");

    /** Static value Fixed for FillNAMethod. */
    public static final FillNAMethod FIXED = fromString("Fixed");

    /**
     * Creates or finds a FillNAMethod from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FillNAMethod.
     */
    @JsonCreator
    public static FillNAMethod fromString(String name) {
        return fromString(name, FillNAMethod.class);
    }

    /**
     * Gets known FillNAMethod values.
     *
     * @return known FillNAMethod values.
     */
    public static Collection<FillNAMethod> values() {
        return values(FillNAMethod.class);
    }
}
