// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Training result of a model including its status, errors and diagnostics information. */
@Fluent
public final class ModelInfo {
    /*
     * Source link to the input data to indicate an accessible Azure storage Uri,
     * either pointed to an Azure blob storage folder, or pointed to a CSV file in
     * Azure blob storage based on you data schema selection.
     */
    @JsonProperty(value = "dataSource", required = true)
    private String dataSource;

    /*
     * Data schema of input data source: OneTable or MultiTable. The default
     * DataSchema is OneTable.
     */
    @JsonProperty(value = "dataSchema")
    private DataSchema dataSchema;

    /*
     * A required field, indicating the start time of training data, which should be
     * date-time of ISO 8601 format.
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * A required field, indicating the end time of training data, which should be
     * date-time of ISO 8601 format.
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /*
     * An optional field. The display name of the model whose maximum length is 24
     * characters.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * An optional field, indicating how many previous timestamps will be used to
     * detect whether the timestamp is anomaly or not.
     */
    @JsonProperty(value = "slidingWindow")
    private Integer slidingWindow;

    /*
     * An optional field, indicating the manner to align multiple variables.
     */
    @JsonProperty(value = "alignPolicy")
    private AlignPolicy alignPolicy;

    /*
     * Model status. One of CREATED, RUNNING, READY, and FAILED.
     */
    @JsonProperty(value = "status")
    private ModelStatus status;

    /*
     * Error messages when failed to create a model.
     */
    @JsonProperty(value = "errors", access = JsonProperty.Access.WRITE_ONLY)
    private List<ErrorResponse> errors;

    /*
     * Diagnostics information to help inspect the states of model or variable.
     */
    @JsonProperty(value = "diagnosticsInfo")
    private DiagnosticsInfo diagnosticsInfo;

    /**
     * Creates an instance of ModelInfo class.
     *
     * @param dataSource the dataSource value to set.
     * @param startTime the startTime value to set.
     * @param endTime the endTime value to set.
     */
    @JsonCreator
    public ModelInfo(
            @JsonProperty(value = "dataSource", required = true) String dataSource,
            @JsonProperty(value = "startTime", required = true) OffsetDateTime startTime,
            @JsonProperty(value = "endTime", required = true) OffsetDateTime endTime) {
        this.dataSource = dataSource;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    /**
     * Get the dataSource property: Source link to the input data to indicate an accessible Azure storage Uri, either
     * pointed to an Azure blob storage folder, or pointed to a CSV file in Azure blob storage based on you data schema
     * selection.
     *
     * @return the dataSource value.
     */
    public String getDataSource() {
        return this.dataSource;
    }

    /**
     * Get the dataSchema property: Data schema of input data source: OneTable or MultiTable. The default DataSchema is
     * OneTable.
     *
     * @return the dataSchema value.
     */
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    /**
     * Set the dataSchema property: Data schema of input data source: OneTable or MultiTable. The default DataSchema is
     * OneTable.
     *
     * @param dataSchema the dataSchema value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setDataSchema(DataSchema dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    /**
     * Get the startTime property: A required field, indicating the start time of training data, which should be
     * date-time of ISO 8601 format.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: A required field, indicating the end time of training data, which should be date-time
     * of ISO 8601 format.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Get the displayName property: An optional field. The display name of the model whose maximum length is 24
     * characters.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: An optional field. The display name of the model whose maximum length is 24
     * characters.
     *
     * @param displayName the displayName value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the slidingWindow property: An optional field, indicating how many previous timestamps will be used to detect
     * whether the timestamp is anomaly or not.
     *
     * @return the slidingWindow value.
     */
    public Integer getSlidingWindow() {
        return this.slidingWindow;
    }

    /**
     * Set the slidingWindow property: An optional field, indicating how many previous timestamps will be used to detect
     * whether the timestamp is anomaly or not.
     *
     * @param slidingWindow the slidingWindow value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setSlidingWindow(Integer slidingWindow) {
        this.slidingWindow = slidingWindow;
        return this;
    }

    /**
     * Get the alignPolicy property: An optional field, indicating the manner to align multiple variables.
     *
     * @return the alignPolicy value.
     */
    public AlignPolicy getAlignPolicy() {
        return this.alignPolicy;
    }

    /**
     * Set the alignPolicy property: An optional field, indicating the manner to align multiple variables.
     *
     * @param alignPolicy the alignPolicy value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setAlignPolicy(AlignPolicy alignPolicy) {
        this.alignPolicy = alignPolicy;
        return this;
    }

    /**
     * Get the status property: Model status. One of CREATED, RUNNING, READY, and FAILED.
     *
     * @return the status value.
     */
    public ModelStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Model status. One of CREATED, RUNNING, READY, and FAILED.
     *
     * @param status the status value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setStatus(ModelStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the errors property: Error messages when failed to create a model.
     *
     * @return the errors value.
     */
    public List<ErrorResponse> getErrors() {
        return this.errors;
    }

    /**
     * Get the diagnosticsInfo property: Diagnostics information to help inspect the states of model or variable.
     *
     * @return the diagnosticsInfo value.
     */
    public DiagnosticsInfo getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    /**
     * Set the diagnosticsInfo property: Diagnostics information to help inspect the states of model or variable.
     *
     * @param diagnosticsInfo the diagnosticsInfo value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setDiagnosticsInfo(DiagnosticsInfo diagnosticsInfo) {
        this.diagnosticsInfo = diagnosticsInfo;
        return this;
    }
}
