// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Detection request for batch inference. This is an asynchronous inference which will need another API to get detection
 * results.
 */
@Immutable
public final class MultivariateBatchDetectionOptions {
    /*
     * Source link to the input data to indicate an accessible Azure storage Uri,
     * either pointed to an Azure blob storage folder, or pointed to a CSV file in
     * Azure blob storage based on you data schema selection. The data schema should
     * be exactly the same with those used in the training phase.
     */
    @JsonProperty(value = "dataSource", required = true)
    private String dataSource;

    /*
     * An optional field, which is used to specify the number of top contributed
     * variables for one anomalous timestamp in the response. The default number is
     * 10.
     */
    @JsonProperty(value = "topContributorCount", required = true)
    private int topContributorCount;

    /*
     * A required field, indicating the start time of data for detection, which should
     * be date-time of ISO 8601 format.
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * A required field, indicating the end time of data for detection, which should
     * be date-time of ISO 8601 format.
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /**
     * Creates an instance of MultivariateBatchDetectionOptions class.
     *
     * @param dataSource the dataSource value to set.
     * @param topContributorCount the topContributorCount value to set.
     * @param startTime the startTime value to set.
     * @param endTime the endTime value to set.
     */
    @JsonCreator
    public MultivariateBatchDetectionOptions(
            @JsonProperty(value = "dataSource", required = true) String dataSource,
            @JsonProperty(value = "topContributorCount", required = true) int topContributorCount,
            @JsonProperty(value = "startTime", required = true) OffsetDateTime startTime,
            @JsonProperty(value = "endTime", required = true) OffsetDateTime endTime) {
        this.dataSource = dataSource;
        this.topContributorCount = topContributorCount;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    /**
     * Get the dataSource property: Source link to the input data to indicate an accessible Azure storage Uri, either
     * pointed to an Azure blob storage folder, or pointed to a CSV file in Azure blob storage based on you data schema
     * selection. The data schema should be exactly the same with those used in the training phase.
     *
     * @return the dataSource value.
     */
    public String getDataSource() {
        return this.dataSource;
    }

    /**
     * Get the topContributorCount property: An optional field, which is used to specify the number of top contributed
     * variables for one anomalous timestamp in the response. The default number is 10.
     *
     * @return the topContributorCount value.
     */
    public int getTopContributorCount() {
        return this.topContributorCount;
    }

    /**
     * Get the startTime property: A required field, indicating the start time of data for detection, which should be
     * date-time of ISO 8601 format.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: A required field, indicating the end time of data for detection, which should be
     * date-time of ISO 8601 format.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }
}
