// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for MultivariateBatchDetectionStatus. */
public enum MultivariateBatchDetectionStatus {
    /** Enum value CREATED. */
    CREATED("CREATED"),

    /** Enum value RUNNING. */
    RUNNING("RUNNING"),

    /** Enum value READY. */
    READY("READY"),

    /** Enum value FAILED. */
    FAILED("FAILED");

    /** The actual serialized value for a MultivariateBatchDetectionStatus instance. */
    private final String value;

    MultivariateBatchDetectionStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MultivariateBatchDetectionStatus instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed MultivariateBatchDetectionStatus object, or null if unable to parse.
     */
    @JsonCreator
    public static MultivariateBatchDetectionStatus fromString(String value) {
        if (value == null) {
            return null;
        }
        MultivariateBatchDetectionStatus[] items = MultivariateBatchDetectionStatus.values();
        for (MultivariateBatchDetectionStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
