// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Detection results for the given resultId. */
@Immutable
public final class MultivariateDetectionResult {
    /*
     * Result identifier, which is used to fetch the results of an inference call.
     */
    @JsonProperty(value = "resultId", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String resultId;

    /*
     * Multivariate anomaly detection status.
     */
    @JsonProperty(value = "summary", required = true)
    private MultivariateBatchDetectionResultSummary summary;

    /*
     * Detection result for each timestamp.
     */
    @JsonProperty(value = "results", required = true)
    private List<AnomalyState> results;

    /**
     * Creates an instance of MultivariateDetectionResult class.
     *
     * @param summary the summary value to set.
     * @param results the results value to set.
     */
    @JsonCreator
    private MultivariateDetectionResult(
            @JsonProperty(value = "summary", required = true) MultivariateBatchDetectionResultSummary summary,
            @JsonProperty(value = "results", required = true) List<AnomalyState> results) {
        this.summary = summary;
        this.results = results;
    }

    /**
     * Get the resultId property: Result identifier, which is used to fetch the results of an inference call.
     *
     * @return the resultId value.
     */
    public String getResultId() {
        return this.resultId;
    }

    /**
     * Get the summary property: Multivariate anomaly detection status.
     *
     * @return the summary value.
     */
    public MultivariateBatchDetectionResultSummary getSummary() {
        return this.summary;
    }

    /**
     * Get the results property: Detection result for each timestamp.
     *
     * @return the results value.
     */
    public List<AnomalyState> getResults() {
        return this.results;
    }
}
