// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Request of last detection. */
@Immutable
public final class MultivariateLastDetectionOptions {
    /*
     * This contains the inference data, including the name, timestamps(ISO 8601) and
     * values of variables.
     */
    @JsonProperty(value = "variables", required = true)
    private List<VariableValues> variables;

    /*
     * An optional field, which is used to specify the number of top contributed
     * variables for one anomalous timestamp in the response. The default number is
     * 10.
     */
    @JsonProperty(value = "topContributorCount", required = true)
    private int topContributorCount;

    /**
     * Creates an instance of MultivariateLastDetectionOptions class.
     *
     * @param variables the variables value to set.
     * @param topContributorCount the topContributorCount value to set.
     */
    @JsonCreator
    public MultivariateLastDetectionOptions(
            @JsonProperty(value = "variables", required = true) List<VariableValues> variables,
            @JsonProperty(value = "topContributorCount", required = true) int topContributorCount) {
        this.variables = variables;
        this.topContributorCount = topContributorCount;
    }

    /**
     * Get the variables property: This contains the inference data, including the name, timestamps(ISO 8601) and values
     * of variables.
     *
     * @return the variables value.
     */
    public List<VariableValues> getVariables() {
        return this.variables;
    }

    /**
     * Get the topContributorCount property: An optional field, which is used to specify the number of top contributed
     * variables for one anomalous timestamp in the response. The default number is 10.
     *
     * @return the topContributorCount value.
     */
    public int getTopContributorCount() {
        return this.topContributorCount;
    }
}
