// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The definition of input timeseries points. */
@Fluent
public final class TimeSeriesPoint {
    /*
     * Optional argument, timestamp of a data point (ISO8601 format).
     */
    @JsonProperty(value = "timestamp")
    private OffsetDateTime timestamp;

    /*
     * The measurement of that point, should be float.
     */
    @JsonProperty(value = "value", required = true)
    private double value;

    /**
     * Creates an instance of TimeSeriesPoint class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    public TimeSeriesPoint(@JsonProperty(value = "value", required = true) double value) {
        this.value = value;
    }

    /**
     * Get the timestamp property: Optional argument, timestamp of a data point (ISO8601 format).
     *
     * @return the timestamp value.
     */
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: Optional argument, timestamp of a data point (ISO8601 format).
     *
     * @param timestamp the timestamp value to set.
     * @return the TimeSeriesPoint object itself.
     */
    public TimeSeriesPoint setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the value property: The measurement of that point, should be float.
     *
     * @return the value value.
     */
    public double getValue() {
        return this.value;
    }
}
