// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The request of change point detection. */
@Fluent
public final class UnivariateChangePointDetectionOptions {
    /*
     * Time series data points. Points should be sorted by timestamp in ascending
     * order to match the change point detection result.
     */
    @JsonProperty(value = "series", required = true)
    private List<TimeSeriesPoint> series;

    /*
     * Can only be one of yearly, monthly, weekly, daily, hourly, minutely or
     * secondly. Granularity is used for verify whether input series is valid.
     */
    @JsonProperty(value = "granularity", required = true)
    private TimeGranularity granularity;

    /*
     * Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely",
     * "customInterval":5}.
     */
    @JsonProperty(value = "customInterval")
    private Integer customInterval;

    /*
     * Optional argument, periodic value of a time series. If the value is null or
     * does not present, the API will determine the period automatically.
     */
    @JsonProperty(value = "period")
    private Integer period;

    /*
     * Optional argument, advanced model parameter, a default stableTrendWindow will
     * be used in detection.
     */
    @JsonProperty(value = "stableTrendWindow")
    private Integer stableTrendWindow;

    /*
     * Optional argument, advanced model parameter, between 0.0-1.0, the lower the
     * value is, the larger the trend error will be which means less change point will
     * be accepted.
     */
    @JsonProperty(value = "threshold")
    private Double threshold;

    /**
     * Creates an instance of UnivariateChangePointDetectionOptions class.
     *
     * @param series the series value to set.
     * @param granularity the granularity value to set.
     */
    @JsonCreator
    public UnivariateChangePointDetectionOptions(
            @JsonProperty(value = "series", required = true) List<TimeSeriesPoint> series,
            @JsonProperty(value = "granularity", required = true) TimeGranularity granularity) {
        this.series = series;
        this.granularity = granularity;
    }

    /**
     * Get the series property: Time series data points. Points should be sorted by timestamp in ascending order to
     * match the change point detection result.
     *
     * @return the series value.
     */
    public List<TimeSeriesPoint> getSeries() {
        return this.series;
    }

    /**
     * Get the granularity property: Can only be one of yearly, monthly, weekly, daily, hourly, minutely or secondly.
     * Granularity is used for verify whether input series is valid.
     *
     * @return the granularity value.
     */
    public TimeGranularity getGranularity() {
        return this.granularity;
    }

    /**
     * Get the customInterval property: Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely", "customInterval":5}.
     *
     * @return the customInterval value.
     */
    public Integer getCustomInterval() {
        return this.customInterval;
    }

    /**
     * Set the customInterval property: Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely", "customInterval":5}.
     *
     * @param customInterval the customInterval value to set.
     * @return the UnivariateChangePointDetectionOptions object itself.
     */
    public UnivariateChangePointDetectionOptions setCustomInterval(Integer customInterval) {
        this.customInterval = customInterval;
        return this;
    }

    /**
     * Get the period property: Optional argument, periodic value of a time series. If the value is null or does not
     * present, the API will determine the period automatically.
     *
     * @return the period value.
     */
    public Integer getPeriod() {
        return this.period;
    }

    /**
     * Set the period property: Optional argument, periodic value of a time series. If the value is null or does not
     * present, the API will determine the period automatically.
     *
     * @param period the period value to set.
     * @return the UnivariateChangePointDetectionOptions object itself.
     */
    public UnivariateChangePointDetectionOptions setPeriod(Integer period) {
        this.period = period;
        return this;
    }

    /**
     * Get the stableTrendWindow property: Optional argument, advanced model parameter, a default stableTrendWindow will
     * be used in detection.
     *
     * @return the stableTrendWindow value.
     */
    public Integer getStableTrendWindow() {
        return this.stableTrendWindow;
    }

    /**
     * Set the stableTrendWindow property: Optional argument, advanced model parameter, a default stableTrendWindow will
     * be used in detection.
     *
     * @param stableTrendWindow the stableTrendWindow value to set.
     * @return the UnivariateChangePointDetectionOptions object itself.
     */
    public UnivariateChangePointDetectionOptions setStableTrendWindow(Integer stableTrendWindow) {
        this.stableTrendWindow = stableTrendWindow;
        return this;
    }

    /**
     * Get the threshold property: Optional argument, advanced model parameter, between 0.0-1.0, the lower the value is,
     * the larger the trend error will be which means less change point will be accepted.
     *
     * @return the threshold value.
     */
    public Double getThreshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: Optional argument, advanced model parameter, between 0.0-1.0, the lower the value is,
     * the larger the trend error will be which means less change point will be accepted.
     *
     * @param threshold the threshold value to set.
     * @return the UnivariateChangePointDetectionOptions object itself.
     */
    public UnivariateChangePointDetectionOptions setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }
}
