// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response of change point detection. */
@Immutable
public final class UnivariateChangePointDetectionResult {
    /*
     * Frequency extracted from the series, zero means no recurrent pattern has been
     * found.
     */
    @JsonProperty(value = "period", access = JsonProperty.Access.WRITE_ONLY)
    private Integer period;

    /*
     * isChangePoint contains change point properties for each input point. True means
     * an anomaly either negative or positive has been detected. The index of the
     * array is consistent with the input series.
     */
    @JsonProperty(value = "isChangePoint")
    private List<Boolean> isChangePoint;

    /*
     * the change point confidence of each point
     */
    @JsonProperty(value = "confidenceScores")
    private List<Double> confidenceScores;

    /** Creates an instance of UnivariateChangePointDetectionResult class. */
    private UnivariateChangePointDetectionResult() {}

    /**
     * Get the period property: Frequency extracted from the series, zero means no recurrent pattern has been found.
     *
     * @return the period value.
     */
    public Integer getPeriod() {
        return this.period;
    }

    /**
     * Get the isChangePoint property: isChangePoint contains change point properties for each input point. True means
     * an anomaly either negative or positive has been detected. The index of the array is consistent with the input
     * series.
     *
     * @return the isChangePoint value.
     */
    public List<Boolean> getIsChangePoint() {
        return this.isChangePoint;
    }

    /**
     * Get the confidenceScores property: the change point confidence of each point.
     *
     * @return the confidenceScores value.
     */
    public List<Double> getConfidenceScores() {
        return this.confidenceScores;
    }
}
