// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The request of entire or last anomaly detection. */
@Fluent
public final class UnivariateDetectionOptions {
    /*
     * Time series data points. Points should be sorted by timestamp in ascending
     * order to match the anomaly detection result. If the data is not sorted
     * correctly or there is duplicated timestamp, the API will not work. In such
     * case, an error message will be returned.
     */
    @JsonProperty(value = "series", required = true)
    private List<TimeSeriesPoint> series;

    /*
     * Optional argument, can be one of yearly, monthly, weekly, daily, hourly,
     * minutely, secondly, microsecond or none. If granularity is not present, it will
     * be none by default. If granularity is none, the timestamp property in time
     * series point can be absent.
     */
    @JsonProperty(value = "granularity")
    private TimeGranularity granularity;

    /*
     * Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely",
     * "customInterval":5}.
     */
    @JsonProperty(value = "customInterval")
    private Integer customInterval;

    /*
     * Optional argument, periodic value of a time series. If the value is null or
     * does not present, the API will determine the period automatically.
     */
    @JsonProperty(value = "period")
    private Integer period;

    /*
     * Optional argument, advanced model parameter, max anomaly ratio in a time series.
     */
    @JsonProperty(value = "maxAnomalyRatio")
    private Double maxAnomalyRatio;

    /*
     * Optional argument, advanced model parameter, between 0-99, the lower the value
     * is, the larger the margin value will be which means less anomalies will be
     * accepted.
     */
    @JsonProperty(value = "sensitivity")
    private Integer sensitivity;

    /*
     * Used to specify how to deal with missing values in the input series, it's used
     * when granularity is not "none".
     */
    @JsonProperty(value = "imputeMode")
    private ImputeMode imputeMode;

    /*
     * Used to specify the value to fill, it's used when granularity is not "none"
     * and imputeMode is "fixed".
     */
    @JsonProperty(value = "imputeFixedValue")
    private Double imputeFixedValue;

    /**
     * Creates an instance of UnivariateDetectionOptions class.
     *
     * @param series the series value to set.
     */
    @JsonCreator
    public UnivariateDetectionOptions(@JsonProperty(value = "series", required = true) List<TimeSeriesPoint> series) {
        this.series = series;
    }

    /**
     * Get the series property: Time series data points. Points should be sorted by timestamp in ascending order to
     * match the anomaly detection result. If the data is not sorted correctly or there is duplicated timestamp, the API
     * will not work. In such case, an error message will be returned.
     *
     * @return the series value.
     */
    public List<TimeSeriesPoint> getSeries() {
        return this.series;
    }

    /**
     * Get the granularity property: Optional argument, can be one of yearly, monthly, weekly, daily, hourly, minutely,
     * secondly, microsecond or none. If granularity is not present, it will be none by default. If granularity is none,
     * the timestamp property in time series point can be absent.
     *
     * @return the granularity value.
     */
    public TimeGranularity getGranularity() {
        return this.granularity;
    }

    /**
     * Set the granularity property: Optional argument, can be one of yearly, monthly, weekly, daily, hourly, minutely,
     * secondly, microsecond or none. If granularity is not present, it will be none by default. If granularity is none,
     * the timestamp property in time series point can be absent.
     *
     * @param granularity the granularity value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setGranularity(TimeGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the customInterval property: Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely", "customInterval":5}.
     *
     * @return the customInterval value.
     */
    public Integer getCustomInterval() {
        return this.customInterval;
    }

    /**
     * Set the customInterval property: Custom Interval is used to set non-standard time interval, for example, if the
     * series is 5 minutes, request can be set as {"granularity":"minutely", "customInterval":5}.
     *
     * @param customInterval the customInterval value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setCustomInterval(Integer customInterval) {
        this.customInterval = customInterval;
        return this;
    }

    /**
     * Get the period property: Optional argument, periodic value of a time series. If the value is null or does not
     * present, the API will determine the period automatically.
     *
     * @return the period value.
     */
    public Integer getPeriod() {
        return this.period;
    }

    /**
     * Set the period property: Optional argument, periodic value of a time series. If the value is null or does not
     * present, the API will determine the period automatically.
     *
     * @param period the period value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setPeriod(Integer period) {
        this.period = period;
        return this;
    }

    /**
     * Get the maxAnomalyRatio property: Optional argument, advanced model parameter, max anomaly ratio in a time
     * series.
     *
     * @return the maxAnomalyRatio value.
     */
    public Double getMaxAnomalyRatio() {
        return this.maxAnomalyRatio;
    }

    /**
     * Set the maxAnomalyRatio property: Optional argument, advanced model parameter, max anomaly ratio in a time
     * series.
     *
     * @param maxAnomalyRatio the maxAnomalyRatio value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setMaxAnomalyRatio(Double maxAnomalyRatio) {
        this.maxAnomalyRatio = maxAnomalyRatio;
        return this;
    }

    /**
     * Get the sensitivity property: Optional argument, advanced model parameter, between 0-99, the lower the value is,
     * the larger the margin value will be which means less anomalies will be accepted.
     *
     * @return the sensitivity value.
     */
    public Integer getSensitivity() {
        return this.sensitivity;
    }

    /**
     * Set the sensitivity property: Optional argument, advanced model parameter, between 0-99, the lower the value is,
     * the larger the margin value will be which means less anomalies will be accepted.
     *
     * @param sensitivity the sensitivity value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setSensitivity(Integer sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    /**
     * Get the imputeMode property: Used to specify how to deal with missing values in the input series, it's used when
     * granularity is not "none".
     *
     * @return the imputeMode value.
     */
    public ImputeMode getImputeMode() {
        return this.imputeMode;
    }

    /**
     * Set the imputeMode property: Used to specify how to deal with missing values in the input series, it's used when
     * granularity is not "none".
     *
     * @param imputeMode the imputeMode value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setImputeMode(ImputeMode imputeMode) {
        this.imputeMode = imputeMode;
        return this;
    }

    /**
     * Get the imputeFixedValue property: Used to specify the value to fill, it's used when granularity is not "none"
     * and imputeMode is "fixed".
     *
     * @return the imputeFixedValue value.
     */
    public Double getImputeFixedValue() {
        return this.imputeFixedValue;
    }

    /**
     * Set the imputeFixedValue property: Used to specify the value to fill, it's used when granularity is not "none"
     * and imputeMode is "fixed".
     *
     * @param imputeFixedValue the imputeFixedValue value to set.
     * @return the UnivariateDetectionOptions object itself.
     */
    public UnivariateDetectionOptions setImputeFixedValue(Double imputeFixedValue) {
        this.imputeFixedValue = imputeFixedValue;
        return this;
    }
}
