// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The response of last anomaly detection. */
@Immutable
public final class UnivariateLastDetectionResult {
    /*
     * Frequency extracted from the series, zero means no recurrent pattern has been
     * found.
     */
    @JsonProperty(value = "period", required = true)
    private int period;

    /*
     * Suggested input series points needed for detecting the latest point.
     */
    @JsonProperty(value = "suggestedWindow", required = true)
    private int suggestedWindow;

    /*
     * Expected value of the latest point.
     */
    @JsonProperty(value = "expectedValue", required = true)
    private double expectedValue;

    /*
     * Upper margin of the latest point. UpperMargin is used to calculate
     * upperBoundary, which equals to expectedValue + (100 - marginScale)*upperMargin.
     * If the value of latest point is between upperBoundary and lowerBoundary, it
     * should be treated as normal value. By adjusting marginScale value, anomaly
     * status of latest point can be changed.
     */
    @JsonProperty(value = "upperMargin", required = true)
    private double upperMargin;

    /*
     * Lower margin of the latest point. LowerMargin is used to calculate
     * lowerBoundary, which equals to expectedValue - (100 - marginScale)*lowerMargin.
     *
     */
    @JsonProperty(value = "lowerMargin", required = true)
    private double lowerMargin;

    /*
     * Anomaly status of the latest point, true means the latest point is an anomaly
     * either in negative direction or positive direction.
     */
    @JsonProperty(value = "isAnomaly", required = true)
    private boolean isAnomaly;

    /*
     * Anomaly status in negative direction of the latest point. True means the latest
     * point is an anomaly and its real value is smaller than the expected one.
     */
    @JsonProperty(value = "isNegativeAnomaly", required = true)
    private boolean isNegativeAnomaly;

    /*
     * Anomaly status in positive direction of the latest point. True means the latest
     * point is an anomaly and its real value is larger than the expected one.
     */
    @JsonProperty(value = "isPositiveAnomaly", required = true)
    private boolean isPositiveAnomaly;

    /*
     * The severity score for the last input point. The larger the value is, the more
     * sever the anomaly is. For normal points, the "severity" is always 0.
     */
    @JsonProperty(value = "severity")
    private Double severity;

    /**
     * Creates an instance of UnivariateLastDetectionResult class.
     *
     * @param period the period value to set.
     * @param suggestedWindow the suggestedWindow value to set.
     * @param expectedValue the expectedValue value to set.
     * @param upperMargin the upperMargin value to set.
     * @param lowerMargin the lowerMargin value to set.
     * @param isAnomaly the isAnomaly value to set.
     * @param isNegativeAnomaly the isNegativeAnomaly value to set.
     * @param isPositiveAnomaly the isPositiveAnomaly value to set.
     */
    @JsonCreator
    private UnivariateLastDetectionResult(
            @JsonProperty(value = "period", required = true) int period,
            @JsonProperty(value = "suggestedWindow", required = true) int suggestedWindow,
            @JsonProperty(value = "expectedValue", required = true) double expectedValue,
            @JsonProperty(value = "upperMargin", required = true) double upperMargin,
            @JsonProperty(value = "lowerMargin", required = true) double lowerMargin,
            @JsonProperty(value = "isAnomaly", required = true) boolean isAnomaly,
            @JsonProperty(value = "isNegativeAnomaly", required = true) boolean isNegativeAnomaly,
            @JsonProperty(value = "isPositiveAnomaly", required = true) boolean isPositiveAnomaly) {
        this.period = period;
        this.suggestedWindow = suggestedWindow;
        this.expectedValue = expectedValue;
        this.upperMargin = upperMargin;
        this.lowerMargin = lowerMargin;
        this.isAnomaly = isAnomaly;
        this.isNegativeAnomaly = isNegativeAnomaly;
        this.isPositiveAnomaly = isPositiveAnomaly;
    }

    /**
     * Get the period property: Frequency extracted from the series, zero means no recurrent pattern has been found.
     *
     * @return the period value.
     */
    public int getPeriod() {
        return this.period;
    }

    /**
     * Get the suggestedWindow property: Suggested input series points needed for detecting the latest point.
     *
     * @return the suggestedWindow value.
     */
    public int getSuggestedWindow() {
        return this.suggestedWindow;
    }

    /**
     * Get the expectedValue property: Expected value of the latest point.
     *
     * @return the expectedValue value.
     */
    public double getExpectedValue() {
        return this.expectedValue;
    }

    /**
     * Get the upperMargin property: Upper margin of the latest point. UpperMargin is used to calculate upperBoundary,
     * which equals to expectedValue + (100 - marginScale)*upperMargin. If the value of latest point is between
     * upperBoundary and lowerBoundary, it should be treated as normal value. By adjusting marginScale value, anomaly
     * status of latest point can be changed.
     *
     * @return the upperMargin value.
     */
    public double getUpperMargin() {
        return this.upperMargin;
    }

    /**
     * Get the lowerMargin property: Lower margin of the latest point. LowerMargin is used to calculate lowerBoundary,
     * which equals to expectedValue - (100 - marginScale)*lowerMargin.
     *
     * @return the lowerMargin value.
     */
    public double getLowerMargin() {
        return this.lowerMargin;
    }

    /**
     * Get the isAnomaly property: Anomaly status of the latest point, true means the latest point is an anomaly either
     * in negative direction or positive direction.
     *
     * @return the isAnomaly value.
     */
    public boolean isAnomaly() {
        return this.isAnomaly;
    }

    /**
     * Get the isNegativeAnomaly property: Anomaly status in negative direction of the latest point. True means the
     * latest point is an anomaly and its real value is smaller than the expected one.
     *
     * @return the isNegativeAnomaly value.
     */
    public boolean isNegativeAnomaly() {
        return this.isNegativeAnomaly;
    }

    /**
     * Get the isPositiveAnomaly property: Anomaly status in positive direction of the latest point. True means the
     * latest point is an anomaly and its real value is larger than the expected one.
     *
     * @return the isPositiveAnomaly value.
     */
    public boolean isPositiveAnomaly() {
        return this.isPositiveAnomaly;
    }

    /**
     * Get the severity property: The severity score for the last input point. The larger the value is, the more sever
     * the anomaly is. For normal points, the "severity" is always 0.
     *
     * @return the severity value.
     */
    public Double getSeverity() {
        return this.severity;
    }
}
