// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Variable Status. */
@Fluent
public final class VariableState {
    /*
     * Variable name in variable states.
     */
    @JsonProperty(value = "variable")
    private String variable;

    /*
     * Proportion of missing values that need to be filled by fillNAMethod.
     */
    @JsonProperty(value = "filledNARatio")
    private Double filledNARatio;

    /*
     * Number of effective data points before applying fillNAMethod.
     */
    @JsonProperty(value = "effectiveCount")
    private Integer effectiveCount;

    /*
     * First valid timestamp with value of input data.
     */
    @JsonProperty(value = "firstTimestamp")
    private OffsetDateTime firstTimestamp;

    /*
     * Last valid timestamp with value of input data.
     */
    @JsonProperty(value = "lastTimestamp")
    private OffsetDateTime lastTimestamp;

    /** Creates an instance of VariableState class. */
    public VariableState() {}

    /**
     * Get the variable property: Variable name in variable states.
     *
     * @return the variable value.
     */
    public String getVariable() {
        return this.variable;
    }

    /**
     * Set the variable property: Variable name in variable states.
     *
     * @param variable the variable value to set.
     * @return the VariableState object itself.
     */
    public VariableState setVariable(String variable) {
        this.variable = variable;
        return this;
    }

    /**
     * Get the filledNARatio property: Proportion of missing values that need to be filled by fillNAMethod.
     *
     * @return the filledNARatio value.
     */
    public Double getFilledNARatio() {
        return this.filledNARatio;
    }

    /**
     * Set the filledNARatio property: Proportion of missing values that need to be filled by fillNAMethod.
     *
     * @param filledNARatio the filledNARatio value to set.
     * @return the VariableState object itself.
     */
    public VariableState setFilledNARatio(Double filledNARatio) {
        this.filledNARatio = filledNARatio;
        return this;
    }

    /**
     * Get the effectiveCount property: Number of effective data points before applying fillNAMethod.
     *
     * @return the effectiveCount value.
     */
    public Integer getEffectiveCount() {
        return this.effectiveCount;
    }

    /**
     * Set the effectiveCount property: Number of effective data points before applying fillNAMethod.
     *
     * @param effectiveCount the effectiveCount value to set.
     * @return the VariableState object itself.
     */
    public VariableState setEffectiveCount(Integer effectiveCount) {
        this.effectiveCount = effectiveCount;
        return this;
    }

    /**
     * Get the firstTimestamp property: First valid timestamp with value of input data.
     *
     * @return the firstTimestamp value.
     */
    public OffsetDateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Set the firstTimestamp property: First valid timestamp with value of input data.
     *
     * @param firstTimestamp the firstTimestamp value to set.
     * @return the VariableState object itself.
     */
    public VariableState setFirstTimestamp(OffsetDateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return this;
    }

    /**
     * Get the lastTimestamp property: Last valid timestamp with value of input data.
     *
     * @return the lastTimestamp value.
     */
    public OffsetDateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    /**
     * Set the lastTimestamp property: Last valid timestamp with value of input data.
     *
     * @param lastTimestamp the lastTimestamp value to set.
     * @return the VariableState object itself.
     */
    public VariableState setLastTimestamp(OffsetDateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }
}
