// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.anomalydetector.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Variable values. */
@Immutable
public final class VariableValues {
    /*
     * Variable name of last detection request.
     */
    @JsonProperty(value = "variable", required = true)
    private String variable;

    /*
     * Timestamps of last detection request
     */
    @JsonProperty(value = "timestamps", required = true)
    private List<String> timestamps;

    /*
     * Values of variables.
     */
    @JsonProperty(value = "values", required = true)
    private List<Double> values;

    /**
     * Creates an instance of VariableValues class.
     *
     * @param variable the variable value to set.
     * @param timestamps the timestamps value to set.
     * @param values the values value to set.
     */
    @JsonCreator
    public VariableValues(
            @JsonProperty(value = "variable", required = true) String variable,
            @JsonProperty(value = "timestamps", required = true) List<String> timestamps,
            @JsonProperty(value = "values", required = true) List<Double> values) {
        this.variable = variable;
        this.timestamps = timestamps;
        this.values = values;
    }

    /**
     * Get the variable property: Variable name of last detection request.
     *
     * @return the variable value.
     */
    public String getVariable() {
        return this.variable;
    }

    /**
     * Get the timestamps property: Timestamps of last detection request.
     *
     * @return the timestamps value.
     */
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    /**
     * Get the values property: Values of variables.
     *
     * @return the values value.
     */
    public List<Double> getValues() {
        return this.values;
    }
}
