/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.anomalydetector;

import com.azure.ai.anomalydetector.AnomalyDetectorClientBuilder;
import com.azure.ai.anomalydetector.implementation.AnomalyDetectorClientImpl;
import com.azure.ai.anomalydetector.models.AnomalyDetectionModel;
import com.azure.ai.anomalydetector.models.ModelInfo;
import com.azure.ai.anomalydetector.models.MultivariateBatchDetectionOptions;
import com.azure.ai.anomalydetector.models.MultivariateDetectionResult;
import com.azure.ai.anomalydetector.models.MultivariateLastDetectionOptions;
import com.azure.ai.anomalydetector.models.MultivariateLastDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateChangePointDetectionOptions;
import com.azure.ai.anomalydetector.models.UnivariateChangePointDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateDetectionOptions;
import com.azure.ai.anomalydetector.models.UnivariateEntireDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateLastDetectionResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AnomalyDetectorClientBuilder.class, isAsync=true)
public final class AnomalyDetectorAsyncClient {
    private final AnomalyDetectorClientImpl serviceClient;

    AnomalyDetectorAsyncClient(AnomalyDetectorClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateEntireSeriesWithResponse(BinaryData options, RequestOptions requestOptions) {
        return this.serviceClient.detectUnivariateEntireSeriesWithResponseAsync(options, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateLastPointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return this.serviceClient.detectUnivariateLastPointWithResponseAsync(options, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateChangePointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return this.serviceClient.detectUnivariateChangePointWithResponseAsync(options, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateBatchDetectionResultWithResponse(String resultId, RequestOptions requestOptions) {
        return this.serviceClient.getMultivariateBatchDetectionResultWithResponseAsync(resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> trainMultivariateModelWithResponse(BinaryData modelInfo, RequestOptions requestOptions) {
        return this.serviceClient.trainMultivariateModelWithResponseAsync(modelInfo, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMultivariateModels(RequestOptions requestOptions) {
        return this.serviceClient.listMultivariateModelsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteMultivariateModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getMultivariateModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateBatchAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return this.serviceClient.detectMultivariateBatchAnomalyWithResponseAsync(modelId, options, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateLastAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return this.serviceClient.detectMultivariateLastAnomalyWithResponseAsync(modelId, options, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UnivariateEntireDetectionResult> detectUnivariateEntireSeries(UnivariateDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return this.detectUnivariateEntireSeriesWithResponse(BinaryData.fromObject((Object)options), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UnivariateEntireDetectionResult)protocolMethodData.toObject(UnivariateEntireDetectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UnivariateLastDetectionResult> detectUnivariateLastPoint(UnivariateDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return this.detectUnivariateLastPointWithResponse(BinaryData.fromObject((Object)options), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UnivariateLastDetectionResult)protocolMethodData.toObject(UnivariateLastDetectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UnivariateChangePointDetectionResult> detectUnivariateChangePoint(UnivariateChangePointDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return this.detectUnivariateChangePointWithResponse(BinaryData.fromObject((Object)options), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UnivariateChangePointDetectionResult)protocolMethodData.toObject(UnivariateChangePointDetectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MultivariateDetectionResult> getMultivariateBatchDetectionResult(String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMultivariateBatchDetectionResultWithResponse(resultId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (MultivariateDetectionResult)protocolMethodData.toObject(MultivariateDetectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionModel> trainMultivariateModel(ModelInfo modelInfo) {
        RequestOptions requestOptions = new RequestOptions();
        return this.trainMultivariateModelWithResponse(BinaryData.fromObject((Object)modelInfo), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AnomalyDetectionModel)protocolMethodData.toObject(AnomalyDetectionModel.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    PagedFlux<AnomalyDetectionModel> listMultivariateModels(Integer skip, Integer top) {
        RequestOptions requestOptions = new RequestOptions();
        if (skip != null) {
            requestOptions.addQueryParam("skip", String.valueOf(skip));
        }
        if (top != null) {
            requestOptions.addQueryParam("top", String.valueOf(top));
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listMultivariateModels(requestOptions);
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationToken).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (AnomalyDetectionModel)protocolMethodData.toObject(AnomalyDetectionModel.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionModel> listMultivariateModels() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listMultivariateModels(requestOptions);
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationToken).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (AnomalyDetectionModel)protocolMethodData.toObject(AnomalyDetectionModel.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMultivariateModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteMultivariateModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionModel> getMultivariateModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMultivariateModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AnomalyDetectionModel)protocolMethodData.toObject(AnomalyDetectionModel.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MultivariateDetectionResult> detectMultivariateBatchAnomaly(String modelId, MultivariateBatchDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return this.detectMultivariateBatchAnomalyWithResponse(modelId, BinaryData.fromObject((Object)options), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (MultivariateDetectionResult)protocolMethodData.toObject(MultivariateDetectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MultivariateLastDetectionResult> detectMultivariateLastAnomaly(String modelId, MultivariateLastDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return this.detectMultivariateLastAnomalyWithResponse(modelId, BinaryData.fromObject((Object)options), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (MultivariateLastDetectionResult)protocolMethodData.toObject(MultivariateLastDetectionResult.class));
    }
}

