/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.anomalydetector;

import com.azure.ai.anomalydetector.AnomalyDetectorAsyncClient;
import com.azure.ai.anomalydetector.AnomalyDetectorClientBuilder;
import com.azure.ai.anomalydetector.models.AnomalyDetectionModel;
import com.azure.ai.anomalydetector.models.ModelInfo;
import com.azure.ai.anomalydetector.models.MultivariateBatchDetectionOptions;
import com.azure.ai.anomalydetector.models.MultivariateDetectionResult;
import com.azure.ai.anomalydetector.models.MultivariateLastDetectionOptions;
import com.azure.ai.anomalydetector.models.MultivariateLastDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateChangePointDetectionOptions;
import com.azure.ai.anomalydetector.models.UnivariateChangePointDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateDetectionOptions;
import com.azure.ai.anomalydetector.models.UnivariateEntireDetectionResult;
import com.azure.ai.anomalydetector.models.UnivariateLastDetectionResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AnomalyDetectorClientBuilder.class)
public final class AnomalyDetectorClient {
    private final AnomalyDetectorAsyncClient client;

    AnomalyDetectorClient(AnomalyDetectorAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateEntireSeriesWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.client.detectUnivariateEntireSeriesWithResponse(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateLastPointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.client.detectUnivariateLastPointWithResponse(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateChangePointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.client.detectUnivariateChangePointWithResponse(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateBatchDetectionResultWithResponse(String resultId, RequestOptions requestOptions) {
        return (Response)this.client.getMultivariateBatchDetectionResultWithResponse(resultId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> trainMultivariateModelWithResponse(BinaryData modelInfo, RequestOptions requestOptions) {
        return (Response)this.client.trainMultivariateModelWithResponse(modelInfo, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMultivariateModels(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listMultivariateModels(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return (Response)this.client.deleteMultivariateModelWithResponse(modelId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return (Response)this.client.getMultivariateModelWithResponse(modelId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateBatchAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return (Response)this.client.detectMultivariateBatchAnomalyWithResponse(modelId, options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateLastAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return (Response)this.client.detectMultivariateLastAnomalyWithResponse(modelId, options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnivariateEntireDetectionResult detectUnivariateEntireSeries(UnivariateDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return (UnivariateEntireDetectionResult)((BinaryData)this.detectUnivariateEntireSeriesWithResponse(BinaryData.fromObject((Object)options), requestOptions).getValue()).toObject(UnivariateEntireDetectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnivariateLastDetectionResult detectUnivariateLastPoint(UnivariateDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return (UnivariateLastDetectionResult)((BinaryData)this.detectUnivariateLastPointWithResponse(BinaryData.fromObject((Object)options), requestOptions).getValue()).toObject(UnivariateLastDetectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnivariateChangePointDetectionResult detectUnivariateChangePoint(UnivariateChangePointDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return (UnivariateChangePointDetectionResult)((BinaryData)this.detectUnivariateChangePointWithResponse(BinaryData.fromObject((Object)options), requestOptions).getValue()).toObject(UnivariateChangePointDetectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MultivariateDetectionResult getMultivariateBatchDetectionResult(String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return (MultivariateDetectionResult)((BinaryData)this.getMultivariateBatchDetectionResultWithResponse(resultId, requestOptions).getValue()).toObject(MultivariateDetectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionModel trainMultivariateModel(ModelInfo modelInfo) {
        RequestOptions requestOptions = new RequestOptions();
        return (AnomalyDetectionModel)((BinaryData)this.trainMultivariateModelWithResponse(BinaryData.fromObject((Object)modelInfo), requestOptions).getValue()).toObject(AnomalyDetectionModel.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    PagedIterable<AnomalyDetectionModel> listMultivariateModels(Integer skip, Integer top) {
        return new PagedIterable(this.client.listMultivariateModels(skip, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionModel> listMultivariateModels() {
        return new PagedIterable(this.client.listMultivariateModels());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMultivariateModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteMultivariateModelWithResponse(modelId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionModel getMultivariateModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AnomalyDetectionModel)((BinaryData)this.getMultivariateModelWithResponse(modelId, requestOptions).getValue()).toObject(AnomalyDetectionModel.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MultivariateDetectionResult detectMultivariateBatchAnomaly(String modelId, MultivariateBatchDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return (MultivariateDetectionResult)((BinaryData)this.detectMultivariateBatchAnomalyWithResponse(modelId, BinaryData.fromObject((Object)options), requestOptions).getValue()).toObject(MultivariateDetectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MultivariateLastDetectionResult detectMultivariateLastAnomaly(String modelId, MultivariateLastDetectionOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        return (MultivariateLastDetectionResult)((BinaryData)this.detectMultivariateLastAnomalyWithResponse(modelId, BinaryData.fromObject((Object)options), requestOptions).getValue()).toObject(MultivariateLastDetectionResult.class);
    }
}

