/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.anomalydetector.implementation;

import com.azure.ai.anomalydetector.AnomalyDetectorServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class AnomalyDetectorClientImpl {
    private final AnomalyDetectorClientService service;
    private final String endpoint;
    private final AnomalyDetectorServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public AnomalyDetectorServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public AnomalyDetectorClientImpl(String endpoint, AnomalyDetectorServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AnomalyDetectorClientImpl(HttpPipeline httpPipeline, String endpoint, AnomalyDetectorServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AnomalyDetectorClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, AnomalyDetectorServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (AnomalyDetectorClientService)RestProxy.create(AnomalyDetectorClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateEntireSeriesWithResponseAsync(BinaryData options, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detectUnivariateEntireSeries(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", options, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateEntireSeriesWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.detectUnivariateEntireSeriesWithResponseAsync(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateLastPointWithResponseAsync(BinaryData options, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detectUnivariateLastPoint(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", options, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateLastPointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.detectUnivariateLastPointWithResponseAsync(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectUnivariateChangePointWithResponseAsync(BinaryData options, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detectUnivariateChangePoint(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", options, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectUnivariateChangePointWithResponse(BinaryData options, RequestOptions requestOptions) {
        return (Response)this.detectUnivariateChangePointWithResponseAsync(options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateBatchDetectionResultWithResponseAsync(String resultId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMultivariateBatchDetectionResult(this.getEndpoint(), this.getServiceVersion().getVersion(), resultId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateBatchDetectionResultWithResponse(String resultId, RequestOptions requestOptions) {
        return (Response)this.getMultivariateBatchDetectionResultWithResponseAsync(resultId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> trainMultivariateModelWithResponseAsync(BinaryData modelInfo, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.trainMultivariateModel(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", modelInfo, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> trainMultivariateModelWithResponse(BinaryData modelInfo, RequestOptions requestOptions) {
        return (Response)this.trainMultivariateModelWithResponseAsync(modelInfo, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMultivariateModelsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMultivariateModels(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "models"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMultivariateModelsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listMultivariateModelsSinglePageAsync(requestOptions), nextLink -> this.listMultivariateModelsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMultivariateModels(RequestOptions requestOptions) {
        return new PagedIterable(this.listMultivariateModelsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMultivariateModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteMultivariateModel(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return (Response)this.deleteMultivariateModelWithResponseAsync(modelId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMultivariateModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMultivariateModel(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMultivariateModelWithResponse(String modelId, RequestOptions requestOptions) {
        return (Response)this.getMultivariateModelWithResponseAsync(modelId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateBatchAnomalyWithResponseAsync(String modelId, BinaryData options, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detectMultivariateBatchAnomaly(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", options, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateBatchAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return (Response)this.detectMultivariateBatchAnomalyWithResponseAsync(modelId, options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> detectMultivariateLastAnomalyWithResponseAsync(String modelId, BinaryData options, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detectMultivariateLastAnomaly(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", options, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> detectMultivariateLastAnomalyWithResponse(String modelId, BinaryData options, RequestOptions requestOptions) {
        return (Response)this.detectMultivariateLastAnomalyWithResponseAsync(modelId, options, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMultivariateModelsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMultivariateModelsNext(nextLink, this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "models"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{Endpoint}/anomalydetector/{ApiVersion}")
    @ServiceInterface(name="AnomalyDetectorClien")
    public static interface AnomalyDetectorClientService {
        @Post(value="/timeseries/entire/detect")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> detectUnivariateEntireSeries(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/timeseries/last/detect")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> detectUnivariateLastPoint(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/timeseries/changepoint/detect")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> detectUnivariateChangePoint(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/multivariate/detect-batch/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getMultivariateBatchDetectionResult(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/multivariate/models")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> trainMultivariateModel(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/multivariate/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMultivariateModels(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/multivariate/models/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteMultivariateModel(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/multivariate/models/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getMultivariateModel(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/multivariate/models/{modelId}:detect-batch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> detectMultivariateBatchAnomaly(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/multivariate/models/{modelId}:detect-last")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> detectMultivariateLastAnomaly(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMultivariateModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="Endpoint") String var2, @HostParam(value="ApiVersion") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);
    }
}

