/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.anomalydetector.models;

import com.azure.ai.anomalydetector.models.AlignPolicy;
import com.azure.ai.anomalydetector.models.DataSchema;
import com.azure.ai.anomalydetector.models.DiagnosticsInfo;
import com.azure.ai.anomalydetector.models.ErrorResponse;
import com.azure.ai.anomalydetector.models.ModelStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ModelInfo {
    @JsonProperty(value="dataSource", required=true)
    private String dataSource;
    @JsonProperty(value="dataSchema")
    private DataSchema dataSchema;
    @JsonProperty(value="startTime", required=true)
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime", required=true)
    private OffsetDateTime endTime;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="slidingWindow")
    private Integer slidingWindow;
    @JsonProperty(value="alignPolicy")
    private AlignPolicy alignPolicy;
    @JsonProperty(value="status")
    private ModelStatus status;
    @JsonProperty(value="errors", access=JsonProperty.Access.WRITE_ONLY)
    private List<ErrorResponse> errors;
    @JsonProperty(value="diagnosticsInfo")
    private DiagnosticsInfo diagnosticsInfo;

    @JsonCreator
    public ModelInfo(@JsonProperty(value="dataSource", required=true) String dataSource, @JsonProperty(value="startTime", required=true) OffsetDateTime startTime, @JsonProperty(value="endTime", required=true) OffsetDateTime endTime) {
        this.dataSource = dataSource;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    public ModelInfo setDataSchema(DataSchema dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ModelInfo setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Integer getSlidingWindow() {
        return this.slidingWindow;
    }

    public ModelInfo setSlidingWindow(Integer slidingWindow) {
        this.slidingWindow = slidingWindow;
        return this;
    }

    public AlignPolicy getAlignPolicy() {
        return this.alignPolicy;
    }

    public ModelInfo setAlignPolicy(AlignPolicy alignPolicy) {
        this.alignPolicy = alignPolicy;
        return this;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public ModelInfo setStatus(ModelStatus status) {
        this.status = status;
        return this;
    }

    public List<ErrorResponse> getErrors() {
        return this.errors;
    }

    public DiagnosticsInfo getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public ModelInfo setDiagnosticsInfo(DiagnosticsInfo diagnosticsInfo) {
        this.diagnosticsInfo = diagnosticsInfo;
        return this;
    }
}

