/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class AuthorizeCopyRequest
implements JsonSerializable<AuthorizeCopyRequest> {
    private final String modelId;
    private String description;
    private Map<String, String> tags;

    public AuthorizeCopyRequest(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public AuthorizeCopyRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public AuthorizeCopyRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AuthorizeCopyRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizeCopyRequest)jsonReader.readObject(reader -> {
            String modelId = null;
            String description = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AuthorizeCopyRequest deserializedAuthorizeCopyRequest = new AuthorizeCopyRequest(modelId);
            deserializedAuthorizeCopyRequest.description = description;
            deserializedAuthorizeCopyRequest.tags = tags;
            return deserializedAuthorizeCopyRequest;
        });
    }
}

