/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentListItem;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentList
implements JsonSerializable<DocumentList> {
    private final List<DocumentSpan> spans;
    private final List<DocumentListItem> items;

    private DocumentList(List<DocumentSpan> spans, List<DocumentListItem> items) {
        this.spans = spans;
        this.items = items;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<DocumentListItem> getItems() {
        return this.items;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentList fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentList)jsonReader.readObject(reader -> {
            List spans = null;
            List items = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("items".equals(fieldName)) {
                    items = reader.readArray(reader1 -> DocumentListItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DocumentList(spans, items);
        });
    }
}

