/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.InnerError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class Error
implements JsonSerializable<Error> {
    private final String code;
    private final String message;
    private String target;
    private List<Error> details;
    private InnerError innererror;

    private Error(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public List<Error> getDetails() {
        return this.details;
    }

    public InnerError getInnererror() {
        return this.innererror;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        return jsonWriter.writeEndObject();
    }

    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return (Error)jsonReader.readObject(reader -> {
            String code = null;
            String message = null;
            String target = null;
            List details = null;
            InnerError innererror = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            Error deserializedError = new Error(code, message);
            deserializedError.target = target;
            deserializedError.details = details;
            deserializedError.innererror = innererror;
            return deserializedError;
        });
    }
}

