/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceClientImpl;
import com.azure.ai.documentintelligence.models.AnalyzeBatchDocumentsOptions;
import com.azure.ai.documentintelligence.models.AnalyzeBatchOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.AnalyzeDocumentOptions;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeOutputFormat;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.ClassifyDocumentOptions;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentContentFormat;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.polling.SyncPoller;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=DocumentIntelligenceClientBuilder.class)
public final class DocumentIntelligenceClient {
    private final DocumentIntelligenceClientImpl serviceClient;

    DocumentIntelligenceClient(DocumentIntelligenceClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultPdfWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultPdfWithResponse(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultFigureWithResponse(String modelId, String resultId, String figureId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultFigureWithResponse(modelId, resultId, figureId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAnalyzeResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeResultWithResponse(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAnalyzeBatchResults(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.listAnalyzeBatchResults(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAnalyzeBatchResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeBatchResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginClassifyDocument(classifierId, classifyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getAnalyzeResultPdf(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getAnalyzeResultPdfWithResponse(modelId, resultId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getAnalyzeResultFigure(String modelId, String resultId, String figureId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getAnalyzeResultFigureWithResponse(modelId, resultId, figureId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAnalyzeResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteAnalyzeResultWithResponse(modelId, resultId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnalyzeBatchOperationDetails> listAnalyzeBatchResults(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listAnalyzeBatchResults(modelId, requestOptions).mapPage(bodyItemValue -> (AnalyzeBatchOperationDetails)bodyItemValue.toObject(AnalyzeBatchOperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAnalyzeBatchResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeBatchOperationDetails getAnalyzeBatchResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AnalyzeBatchOperationDetails)((BinaryData)this.getAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).getValue()).toObject(AnalyzeBatchOperationDetails.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId, ClassifyDocumentOptions classifyRequest, StringIndexType stringIndexType, SplitMode split, String pages) {
        RequestOptions requestOptions = new RequestOptions();
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (split != null) {
            requestOptions.addQueryParam("split", split.toString(), false);
        }
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        return this.serviceClient.beginClassifyDocumentWithModel(classifierId, BinaryData.fromObject((Object)classifyRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId, ClassifyDocumentOptions classifyDocumentOptions) {
        Objects.requireNonNull(classifyDocumentOptions, "'classifyDocumentOptions' cannot be null.");
        return this.beginClassifyDocument(classifierId, classifyDocumentOptions, classifyDocumentOptions.getStringIndexType(), classifyDocumentOptions.getSplit(), classifyDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", classifyDocumentOptions.getPages()) : null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, BinaryData analyzeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeDocument(modelId, analyzeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeBatchDocuments(String modelId, BinaryData analyzeBatchRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeBatchDocuments(modelId, analyzeBatchRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId, AnalyzeDocumentOptions analyzeRequest, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat, List<AnalyzeOutputFormat> output) {
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features", features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields", queryFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output", output.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.beginAnalyzeDocumentWithModel(modelId, BinaryData.fromObject((Object)analyzeRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId, AnalyzeDocumentOptions analyzeDocumentOptions) {
        Objects.requireNonNull(analyzeDocumentOptions, "'analyzeDocumentOptions' cannot be null.");
        return this.beginAnalyzeDocument(modelId, analyzeDocumentOptions, analyzeDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", analyzeDocumentOptions.getPages()) : null, analyzeDocumentOptions.getLocale(), analyzeDocumentOptions.getStringIndexType(), analyzeDocumentOptions.getDocumentAnalysisFeatures(), analyzeDocumentOptions.getQueryFields(), analyzeDocumentOptions.getOutputContentFormat(), analyzeDocumentOptions.getOutput());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId, AnalyzeBatchDocumentsOptions analyzeBatchRequest, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat, List<AnalyzeOutputFormat> output) {
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features", features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields", queryFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output", output.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.beginAnalyzeBatchDocumentsWithModel(modelId, BinaryData.fromObject((Object)analyzeBatchRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId, AnalyzeBatchDocumentsOptions analyzeBatchDocumentOptions) {
        Objects.requireNonNull(analyzeBatchDocumentOptions, "'analyzeBatchDocumentOptions' cannot be null.");
        return this.beginAnalyzeBatchDocuments(modelId, analyzeBatchDocumentOptions, analyzeBatchDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", analyzeBatchDocumentOptions.getPages()) : null, analyzeBatchDocumentOptions.getLocale(), analyzeBatchDocumentOptions.getStringIndexType(), analyzeBatchDocumentOptions.getDocumentAnalysisFeatures(), analyzeBatchDocumentOptions.getQueryFields(), analyzeBatchDocumentOptions.getOutputContentFormat(), analyzeBatchDocumentOptions.getOutput());
    }
}

