/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DocumentIntelligenceWarning
implements JsonSerializable<DocumentIntelligenceWarning> {
    private final String code;
    private final String message;
    private String target;

    private DocumentIntelligenceWarning(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    public static DocumentIntelligenceWarning fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentIntelligenceWarning)jsonReader.readObject(reader -> {
            String code = null;
            String message = null;
            String target = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            DocumentIntelligenceWarning deserializedDocumentIntelligenceWarning = new DocumentIntelligenceWarning(code, message);
            deserializedDocumentIntelligenceWarning.target = target;
            return deserializedDocumentIntelligenceWarning;
        });
    }
}

