/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentLanguage
implements JsonSerializable<DocumentLanguage> {
    private final String locale;
    private final List<DocumentSpan> spans;
    private final double confidence;

    private DocumentLanguage(String locale, List<DocumentSpan> spans, double confidence) {
        this.locale = locale;
        this.spans = spans;
        this.confidence = confidence;
    }

    public String getLocale() {
        return this.locale;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", this.locale);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DocumentLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentLanguage)jsonReader.readObject(reader -> {
            String locale = null;
            List spans = null;
            double confidence = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locale".equals(fieldName)) {
                    locale = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new DocumentLanguage(locale, spans, confidence);
        });
    }
}

