/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.DocumentAnalysisAsyncClient;
import com.azure.ai.formrecognizer.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.implementation.util.Utility;
import com.azure.ai.formrecognizer.models.AnalyzeDocumentOptions;
import com.azure.ai.formrecognizer.models.AnalyzeResult;
import com.azure.ai.formrecognizer.models.DocumentOperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

@ServiceClient(builder=DocumentAnalysisClientBuilder.class)
public final class DocumentAnalysisClient {
    private final DocumentAnalysisAsyncClient client;

    DocumentAnalysisClient(DocumentAnalysisAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl) {
        return this.beginAnalyzeDocumentFromUrl(modelId, documentUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        return this.client.beginAnalyzeDocumentFromUrl(documentUrl, modelId, analyzeDocumentOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, InputStream document, long length) {
        return this.beginAnalyzeDocument(modelId, document, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, InputStream document, long length, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(document);
        return this.client.beginAnalyzeDocument(modelId, buffer, length, analyzeDocumentOptions, context).getSyncPoller();
    }
}

