/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.administration;

import com.azure.ai.formrecognizer.DocumentAnalysisAsyncClient;
import com.azure.ai.formrecognizer.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.DocumentAnalysisServiceVersion;
import com.azure.ai.formrecognizer.administration.DocumentModelAdministrationClientBuilder;
import com.azure.ai.formrecognizer.administration.models.AccountProperties;
import com.azure.ai.formrecognizer.administration.models.BuildModelOptions;
import com.azure.ai.formrecognizer.administration.models.CopyAuthorization;
import com.azure.ai.formrecognizer.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.administration.models.CreateComposedModelOptions;
import com.azure.ai.formrecognizer.administration.models.DocumentBuildMode;
import com.azure.ai.formrecognizer.administration.models.DocumentModel;
import com.azure.ai.formrecognizer.administration.models.DocumentModelInfo;
import com.azure.ai.formrecognizer.administration.models.ModelOperation;
import com.azure.ai.formrecognizer.administration.models.ModelOperationInfo;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.implementation.models.AzureBlobContentSource;
import com.azure.ai.formrecognizer.implementation.models.BuildDocumentModelHeaders;
import com.azure.ai.formrecognizer.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.implementation.models.ComponentModelInfo;
import com.azure.ai.formrecognizer.implementation.models.ComposeDocumentModelHeaders;
import com.azure.ai.formrecognizer.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.implementation.models.CopyDocumentModelToHeaders;
import com.azure.ai.formrecognizer.implementation.models.GetInfoResponse;
import com.azure.ai.formrecognizer.implementation.models.GetOperationResponse;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.util.Constants;
import com.azure.ai.formrecognizer.implementation.util.Transforms;
import com.azure.ai.formrecognizer.implementation.util.Utility;
import com.azure.ai.formrecognizer.models.DocumentOperationResult;
import com.azure.ai.formrecognizer.models.FormRecognizerAudience;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentModelAdministrationClientBuilder.class, isAsync=true)
public final class DocumentModelAdministrationAsyncClient {
    private final ClientLogger logger = new ClientLogger(DocumentModelAdministrationAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final DocumentAnalysisServiceVersion serviceVersion;
    private final FormRecognizerAudience audience;

    DocumentModelAdministrationAsyncClient(FormRecognizerClientImpl service, DocumentAnalysisServiceVersion serviceVersion, FormRecognizerAudience audience) {
        this.service = service;
        this.serviceVersion = serviceVersion;
        this.audience = audience;
    }

    public DocumentAnalysisAsyncClient getDocumentAnalysisAsyncClient() {
        return new DocumentAnalysisClientBuilder().endpoint(this.getEndpoint()).pipeline(this.getHttpPipeline()).audience(this.audience).buildAsyncClient();
    }

    HttpPipeline getHttpPipeline() {
        return this.service.getHttpPipeline();
    }

    String getEndpoint() {
        return this.service.getEndpoint();
    }

    FormRecognizerAudience getAudience() {
        return this.audience;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentOperationResult, DocumentModel> beginBuildModel(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId) {
        return this.beginBuildModel(trainingFilesUrl, buildMode, modelId, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentOperationResult, DocumentModel> beginBuildModel(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId, BuildModelOptions buildModelOptions) {
        return this.beginBuildModel(trainingFilesUrl, buildMode, modelId, buildModelOptions, Context.NONE);
    }

    PollerFlux<DocumentOperationResult, DocumentModel> beginBuildModel(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId, BuildModelOptions buildModelOptions, Context context) {
        buildModelOptions = buildModelOptions == null ? new BuildModelOptions() : buildModelOptions;
        return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, this.buildModelActivationOperation(trainingFilesUrl, buildMode, modelId, buildModelOptions, context), this.createModelPollOperation(context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccountProperties> getAccountProperties() {
        return this.getAccountPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccountProperties>> getAccountPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AccountProperties>> getAccountPropertiesWithResponse(Context context) {
        return this.service.getInfoWithResponseAsync(context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toAccountProperties((GetInfoResponse)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModel(String modelId) {
        return this.deleteModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.deleteModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        return this.service.deleteModelWithResponseAsync(modelId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> getCopyAuthorization(String modelId) {
        return this.getCopyAuthorizationWithResponse(modelId, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> getCopyAuthorizationWithResponse(String modelId, CopyAuthorizationOptions copyAuthorizationOptions) {
        try {
            return FluxUtil.withContext(context -> this.getCopyAuthorizationWithResponse(modelId, copyAuthorizationOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CopyAuthorization>> getCopyAuthorizationWithResponse(String modelId, CopyAuthorizationOptions copyAuthorizationOptions, Context context) {
        copyAuthorizationOptions = copyAuthorizationOptions == null ? new CopyAuthorizationOptions() : copyAuthorizationOptions;
        modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
        AuthorizeCopyRequest authorizeCopyRequest = new AuthorizeCopyRequest().setModelId(modelId).setDescription(copyAuthorizationOptions.getDescription()).setTags(copyAuthorizationOptions.getTags());
        return this.service.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toCopyAuthorization((com.azure.ai.formrecognizer.implementation.models.CopyAuthorization)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentOperationResult, DocumentModel> beginCreateComposedModel(List<String> modelIDs, String modelId) {
        return this.beginCreateComposedModel(modelIDs, modelId, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentOperationResult, DocumentModel> beginCreateComposedModel(List<String> modelIDs, String modelId, CreateComposedModelOptions createComposedModelOptions) {
        return this.beginCreateComposedModel(modelIDs, modelId, createComposedModelOptions, Context.NONE);
    }

    PollerFlux<DocumentOperationResult, DocumentModel> beginCreateComposedModel(List<String> modelIDs, String modelId, CreateComposedModelOptions createComposedModelOptions, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty(modelIDs)) {
                throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'modelIDs' cannot be null or empty"));
            }
            modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
            createComposedModelOptions = DocumentModelAdministrationAsyncClient.getCreateComposeModelOptions(createComposedModelOptions);
            ComposeDocumentModelRequest composeRequest = new ComposeDocumentModelRequest().setComponentModels(modelIDs.stream().map(modelIdString -> new ComponentModelInfo().setModelId((String)modelIdString)).collect(Collectors.toList())).setModelId(modelId).setDescription(createComposedModelOptions.getDescription()).setTags(createComposedModelOptions.getTags());
            return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, Utility.activationOperation(() -> this.service.composeDocumentModelWithResponseAsync(composeRequest, context).map(response -> Transforms.toDocumentOperationResult(((ComposeDocumentModelHeaders)response.getDeserializedHeaders()).getOperationLocation())), this.logger), this.createModelPollOperation(context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchModelResultOperation(context));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentOperationResult, DocumentModel> beginCopyModel(String modelId, CopyAuthorization target) {
        return this.beginCopyModel(modelId, target, null);
    }

    PollerFlux<DocumentOperationResult, DocumentModel> beginCopyModel(String modelId, CopyAuthorization target, Context context) {
        return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, this.getCopyActivationOperation(modelId, target, context), this.createModelPollOperation(context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelInfo> listModels() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageModelInfo), continuationToken -> FluxUtil.withContext(context -> this.listNextPageModelInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DocumentModelInfo> listModels(Context context) {
        return new PagedFlux(() -> this.listFirstPageModelInfo(context), continuationToken -> this.listNextPageModelInfo((String)continuationToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModel> getModel(String modelId) {
        return this.getModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModel>> getModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.getModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DocumentModel>> getModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        return this.service.getModelWithResponseAsync(modelId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toDocumentModel((ModelInfo)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ModelOperation> getOperation(String operationId) {
        return this.getOperationWithResponse(operationId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ModelOperation>> getOperationWithResponse(String operationId) {
        try {
            return FluxUtil.withContext(context -> this.getOperationWithResponse(operationId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ModelOperation>> getOperationWithResponse(String operationId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)operationId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'operationId' is required and cannot be null or empty"));
        }
        return this.service.getOperationWithResponseAsync(operationId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toModelOperation((GetOperationResponse)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelOperationInfo> listOperations() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageOperationInfo), continuationToken -> FluxUtil.withContext(context -> this.listNextPageOperationInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<ModelOperationInfo> listOperations(Context context) {
        return new PagedFlux(() -> this.listFirstPageOperationInfo(context), continuationToken -> this.listNextPageOperationInfo((String)continuationToken, context));
    }

    private Function<PollingContext<DocumentOperationResult>, Mono<DocumentModel>> fetchModelResultOperation(Context context) {
        return pollingContext -> {
            try {
                String modelId = ((DocumentOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
                return this.service.getOperationAsync(modelId, context).map(modelSimpleResponse -> Transforms.toDocumentModel(modelSimpleResponse.getResult())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<DocumentOperationResult>, Mono<PollResponse<DocumentOperationResult>>> createModelPollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                String modelId = ((DocumentOperationResult)operationResultPollResponse.getValue()).getResultId();
                return this.service.getOperationAsync(modelId, context).flatMap(modelSimpleResponse -> this.processBuildingModelResponse((GetOperationResponse)modelSimpleResponse, (PollResponse<DocumentOperationResult>)operationResultPollResponse)).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (HttpResponseException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)ex));
            }
        };
    }

    private Function<PollingContext<DocumentOperationResult>, Mono<DocumentOperationResult>> buildModelActivationOperation(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId, BuildModelOptions buildModelOptions, Context context) {
        if (modelId == null) {
            modelId = Utility.generateRandomModelID();
        }
        String finalModelId = modelId;
        return pollingContext -> {
            try {
                Objects.requireNonNull(trainingFilesUrl, "'trainingFilesUrl' cannot be null.");
                BuildDocumentModelRequest buildDocumentModelRequest = new BuildDocumentModelRequest().setModelId(finalModelId).setBuildMode(com.azure.ai.formrecognizer.implementation.models.DocumentBuildMode.fromString(buildMode.toString())).setAzureBlobSource(new AzureBlobContentSource().setContainerUrl(trainingFilesUrl).setPrefix(buildModelOptions.getPrefix())).setDescription(buildModelOptions.getDescription()).setTags(buildModelOptions.getTags());
                return this.service.buildDocumentModelWithResponseAsync(buildDocumentModelRequest, context).map(response -> Transforms.toDocumentOperationResult(((BuildDocumentModelHeaders)response.getDeserializedHeaders()).getOperationLocation())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<DocumentOperationResult>> processBuildingModelResponse(GetOperationResponse getOperationResponse, PollResponse<DocumentOperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (getOperationResponse.getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)Transforms.toDocumentModelOperationException(getOperationResponse.getError())));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)getOperationResponse.getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((DocumentOperationResult)trainingModelOperationResponse.getValue())));
    }

    private Function<PollingContext<DocumentOperationResult>, Mono<DocumentOperationResult>> getCopyActivationOperation(String modelId, CopyAuthorization target, Context context) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(modelId, "'modelId' cannot be null.");
                Objects.requireNonNull(target, "'target' cannot be null.");
                com.azure.ai.formrecognizer.implementation.models.CopyAuthorization copyRequest = new com.azure.ai.formrecognizer.implementation.models.CopyAuthorization().setTargetModelLocation(target.getTargetModelLocation()).setTargetResourceId(target.getTargetResourceId()).setTargetResourceRegion(target.getTargetResourceRegion()).setTargetModelId(target.getTargetModelId()).setAccessToken(target.getAccessToken()).setExpirationDateTime(target.getExpiresOn());
                return this.service.copyDocumentModelToWithResponseAsync(modelId, copyRequest, context).map(response -> Transforms.toDocumentOperationResult(((CopyDocumentModelToHeaders)response.getDeserializedHeaders()).getOperationLocation())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PagedResponse<DocumentModelInfo>> listFirstPageModelInfo(Context context) {
        return this.service.getModelsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all models")).doOnSuccess(response -> this.logger.info("Listed all models")).doOnError(error -> this.logger.warning("Failed to list all models information", new Object[]{error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<DocumentModelInfo>> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.getModelsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<ModelOperationInfo>> listFirstPageOperationInfo(Context context) {
        return this.service.getOperationsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all operations")).doOnSuccess(response -> this.logger.info("Listed all operations")).doOnError(error -> this.logger.warning("Failed to list all operations information", new Object[]{error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toModelOperationInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<ModelOperationInfo>> listNextPageOperationInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.getOperationsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toModelOperationInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private static CreateComposedModelOptions getCreateComposeModelOptions(CreateComposedModelOptions userProvidedOptions) {
        return userProvidedOptions == null ? new CreateComposedModelOptions() : userProvidedOptions;
    }
}

