/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.administration;

import com.azure.ai.formrecognizer.DocumentAnalysisClient;
import com.azure.ai.formrecognizer.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.administration.DocumentModelAdministrationAsyncClient;
import com.azure.ai.formrecognizer.administration.DocumentModelAdministrationClientBuilder;
import com.azure.ai.formrecognizer.administration.models.AccountProperties;
import com.azure.ai.formrecognizer.administration.models.BuildModelOptions;
import com.azure.ai.formrecognizer.administration.models.CopyAuthorization;
import com.azure.ai.formrecognizer.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.administration.models.CreateComposedModelOptions;
import com.azure.ai.formrecognizer.administration.models.DocumentBuildMode;
import com.azure.ai.formrecognizer.administration.models.DocumentModel;
import com.azure.ai.formrecognizer.administration.models.DocumentModelInfo;
import com.azure.ai.formrecognizer.administration.models.ModelOperation;
import com.azure.ai.formrecognizer.administration.models.ModelOperationInfo;
import com.azure.ai.formrecognizer.models.DocumentOperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.util.List;

@ServiceClient(builder=DocumentModelAdministrationClientBuilder.class)
public final class DocumentModelAdministrationClient {
    private final DocumentModelAdministrationAsyncClient client;

    DocumentModelAdministrationClient(DocumentModelAdministrationAsyncClient documentAnalysisTrainingAsyncClient) {
        this.client = documentAnalysisTrainingAsyncClient;
    }

    public DocumentAnalysisClient getDocumentAnalysisClient() {
        return new DocumentAnalysisClientBuilder().endpoint(this.client.getEndpoint()).pipeline(this.client.getHttpPipeline()).audience(this.client.getAudience()).buildClient();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginBuildModel(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId) {
        return this.beginBuildModel(trainingFilesUrl, buildMode, modelId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginBuildModel(String trainingFilesUrl, DocumentBuildMode buildMode, String modelId, BuildModelOptions buildModelOptions, Context context) {
        return this.client.beginBuildModel(trainingFilesUrl, buildMode, modelId, buildModelOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccountProperties getAccountProperties() {
        return (AccountProperties)this.getAccountPropertiesWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccountProperties> getAccountPropertiesWithResponse(Context context) {
        return (Response)this.client.getAccountPropertiesWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        return (Response)this.client.deleteModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization getCopyAuthorization(String modelId) {
        return (CopyAuthorization)this.getCopyAuthorizationWithResponse(modelId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> getCopyAuthorizationWithResponse(String modelId, CopyAuthorizationOptions copyAuthorizationOptions, Context context) {
        return (Response)this.client.getCopyAuthorizationWithResponse(modelId, copyAuthorizationOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginCreateComposedModel(List<String> modelIDs, String modelId) {
        return this.beginCreateComposedModel(modelIDs, modelId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginCreateComposedModel(List<String> modelIDs, String modelId, CreateComposedModelOptions createComposedModelOptions, Context context) {
        return this.client.beginCreateComposedModel(modelIDs, modelId, createComposedModelOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginCopyModel(String modelId, CopyAuthorization target) {
        return this.beginCopyModel(modelId, target, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentOperationResult, DocumentModel> beginCopyModel(String modelId, CopyAuthorization target, Context context) {
        return this.client.beginCopyModel(modelId, target, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelInfo> listModels() {
        return new PagedIterable(this.client.listModels(Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelInfo> listModels(Context context) {
        return new PagedIterable(this.client.listModels(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModel getModel(String modelId) {
        return (DocumentModel)this.getModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModel> getModelWithResponse(String modelId, Context context) {
        return (Response)this.client.getModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ModelOperation getOperation(String operationId) {
        return (ModelOperation)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ModelOperation> getOperationWithResponse(String operationId, Context context) {
        return (Response)this.client.getOperationWithResponse(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelOperationInfo> listOperations() {
        return new PagedIterable(this.client.listOperations(Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelOperationInfo> listOperations(Context context) {
        return new PagedIterable(this.client.listOperations(context));
    }
}

