/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeDocumentResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.implementation.models.BuildDocumentModelResponse;
import com.azure.ai.formrecognizer.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.implementation.models.ComposeDocumentModelResponse;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.implementation.models.CopyDocumentModelToResponse;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.GetInfoResponse;
import com.azure.ai.formrecognizer.implementation.models.GetModelsResponse;
import com.azure.ai.formrecognizer.implementation.models.GetOperationResponse;
import com.azure.ai.formrecognizer.implementation.models.GetOperationsResponse;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.ModelSummary;
import com.azure.ai.formrecognizer.implementation.models.OperationInfo;
import com.azure.ai.formrecognizer.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FormRecognizerClientImpl {
    private final FormRecognizerClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    FormRecognizerClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service = (FormRecognizerClientService)RestProxy.create(FormRecognizerClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeDocumentResponse> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeDocumentResponse> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeDocument(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        this.analyzeDocumentAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeDocumentResponse analyzeDocumentWithResponse(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return (AnalyzeDocumentResponse)((Object)this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeDocumentResponse> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), analyzeRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeDocumentResponse> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        return this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        this.analyzeDocumentAsync(modelId, pages, locale, stringIndexType, analyzeRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeDocumentResponse analyzeDocumentWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return (AnalyzeDocumentResponse)((Object)this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(String modelId, String resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeDocumentResult(this.getEndpoint(), modelId, resultId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(String modelId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeDocumentResult(this.getEndpoint(), modelId, resultId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(String modelId, String resultId) {
        return this.getAnalyzeDocumentResultWithResponseAsync(modelId, resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeResultOperation)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(String modelId, String resultId, Context context) {
        return this.getAnalyzeDocumentResultWithResponseAsync(modelId, resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeResultOperation)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeDocumentResult(String modelId, String resultId) {
        return (AnalyzeResultOperation)this.getAnalyzeDocumentResultAsync(modelId, resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeDocumentResultWithResponse(String modelId, String resultId, Context context) {
        return (Response)this.getAnalyzeDocumentResultWithResponseAsync(modelId, resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildDocumentModelResponse> buildDocumentModelWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.buildDocumentModel(this.getEndpoint(), this.getApiVersion(), buildRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildDocumentModelResponse> buildDocumentModelWithResponseAsync(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildDocumentModel(this.getEndpoint(), this.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> buildDocumentModelAsync(BuildDocumentModelRequest buildRequest) {
        return this.buildDocumentModelWithResponseAsync(buildRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> buildDocumentModelAsync(BuildDocumentModelRequest buildRequest, Context context) {
        return this.buildDocumentModelWithResponseAsync(buildRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void buildDocumentModel(BuildDocumentModelRequest buildRequest) {
        this.buildDocumentModelAsync(buildRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildDocumentModelResponse buildDocumentModelWithResponse(BuildDocumentModelRequest buildRequest, Context context) {
        return (BuildDocumentModelResponse)((Object)this.buildDocumentModelWithResponseAsync(buildRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ComposeDocumentModelResponse> composeDocumentModelWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.composeDocumentModel(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ComposeDocumentModelResponse> composeDocumentModelWithResponseAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeDocumentModel(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeDocumentModelAsync(ComposeDocumentModelRequest composeRequest) {
        return this.composeDocumentModelWithResponseAsync(composeRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeDocumentModelAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        return this.composeDocumentModelWithResponseAsync(composeRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void composeDocumentModel(ComposeDocumentModelRequest composeRequest) {
        this.composeDocumentModelAsync(composeRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComposeDocumentModelResponse composeDocumentModelWithResponse(ComposeDocumentModelRequest composeRequest, Context context) {
        return (ComposeDocumentModelResponse)((Object)this.composeDocumentModelWithResponseAsync(composeRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.authorizeCopyDocumentModel(this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        String accept = "application/json";
        return this.service.authorizeCopyDocumentModel(this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return this.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CopyAuthorization)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return this.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CopyAuthorization)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization authorizeCopyDocumentModel(AuthorizeCopyRequest authorizeCopyRequest) {
        return (CopyAuthorization)this.authorizeCopyDocumentModelAsync(authorizeCopyRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeCopyDocumentModelWithResponse(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return (Response)this.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyDocumentModelToResponse> copyDocumentModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.copyDocumentModelTo(this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyDocumentModelToResponse> copyDocumentModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyDocumentModelTo(this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyDocumentModelToAsync(String modelId, CopyAuthorization copyToRequest) {
        return this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyDocumentModelToAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        return this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void copyDocumentModelTo(String modelId, CopyAuthorization copyToRequest) {
        this.copyDocumentModelToAsync(modelId, copyToRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyDocumentModelToResponse copyDocumentModelToWithResponse(String modelId, CopyAuthorization copyToRequest, Context context) {
        return (CopyDocumentModelToResponse)((Object)this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationInfo>> getOperationsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperations(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationInfo>> getOperationsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.getOperations(this.getEndpoint(), this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationInfo> getOperationsAsync() {
        return new PagedFlux(() -> this.getOperationsSinglePageAsync(), nextLink -> this.getOperationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationInfo> getOperationsAsync(Context context) {
        return new PagedFlux(() -> this.getOperationsSinglePageAsync(context), nextLink -> this.getOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationInfo> getOperations() {
        return new PagedIterable(this.getOperationsAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationInfo> getOperations(Context context) {
        return new PagedIterable(this.getOperationsAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GetOperationResponse>> getOperationWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GetOperationResponse>> getOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetOperationResponse> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((GetOperationResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetOperationResponse> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((GetOperationResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetOperationResponse getOperation(String operationId) {
        return (GetOperationResponse)this.getOperationAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetOperationResponse> getOperationWithResponse(String operationId, Context context) {
        return (Response)this.getOperationWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelSummary>> getModelsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getModels(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetModelsResponse)res.getValue()).getValue(), ((GetModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelSummary>> getModelsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.getModels(this.getEndpoint(), this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetModelsResponse)res.getValue()).getValue(), ((GetModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelSummary> getModelsAsync() {
        return new PagedFlux(() -> this.getModelsSinglePageAsync(), nextLink -> this.getModelsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelSummary> getModelsAsync(Context context) {
        return new PagedFlux(() -> this.getModelsSinglePageAsync(context), nextLink -> this.getModelsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelSummary> getModels() {
        return new PagedIterable(this.getModelsAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelSummary> getModels(Context context) {
        return new PagedIterable(this.getModelsAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ModelInfo>> getModelWithResponseAsync(String modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ModelInfo>> getModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.getModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ModelInfo> getModelAsync(String modelId) {
        return this.getModelWithResponseAsync(modelId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ModelInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ModelInfo> getModelAsync(String modelId, Context context) {
        return this.getModelWithResponseAsync(modelId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ModelInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ModelInfo getModel(String modelId) {
        return (ModelInfo)this.getModelAsync(modelId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ModelInfo> getModelWithResponse(String modelId, Context context) {
        return (Response)this.getModelWithResponseAsync(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId) {
        return this.deleteModelWithResponseAsync(modelId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId, Context context) {
        return this.deleteModelWithResponseAsync(modelId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        this.deleteModelAsync(modelId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        return (Response)this.deleteModelWithResponseAsync(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GetInfoResponse>> getInfoWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInfo(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GetInfoResponse>> getInfoWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.getInfo(this.getEndpoint(), this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetInfoResponse> getInfoAsync() {
        return this.getInfoWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((GetInfoResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetInfoResponse> getInfoAsync(Context context) {
        return this.getInfoWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((GetInfoResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetInfoResponse getInfo() {
        return (GetInfoResponse)this.getInfoAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetInfoResponse> getInfoWithResponse(Context context) {
        return (Response)this.getInfoWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationInfo>> getOperationsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationInfo>> getOperationsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getOperationsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelSummary>> getModelsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getModelsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetModelsResponse)res.getValue()).getValue(), ((GetModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelSummary>> getModelsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getModelsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetModelsResponse)res.getValue()).getValue(), ((GetModelsResponse)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}/formrecognizer")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface FormRecognizerClientService {
        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeDocumentResponse> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Content-Type") ContentType var7, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeDocumentResponse> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AnalyzeDocumentRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResult(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<BuildDocumentModelResponse> buildDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ComposeDocumentModelResponse> composeDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AuthorizeCopyRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<CopyDocumentModelToResponse> copyDocumentModelTo(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> getOperations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationResponse>> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetModelsResponse>> getModels(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ModelInfo>> getModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetInfoResponse>> getInfo(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> getOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetModelsResponse>> getModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

